/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.views;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.InvalidPathException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.internal.GenericMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DatabaseURL;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class GenericConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private static final Log log = Log.getLog(GenericConnectionPage.class);
    private Text hostText;
    private Text portText;
    private Text serverText;
    private Text dbText;
    private Text pathText;
    private Text urlText;
    private boolean isCustom;
    private DatabaseURL.MetaURL metaURL;
    private Collection<String> controlGroupsByUrl;
    private Composite settingsGroup;
    private static final String GROUP_URL = "url";
    private static final String GROUP_HOST = "host";
    private static final String GROUP_SERVER = "server";
    private static final String GROUP_DB = "db";
    private static final String GROUP_PATH = "path";
    private static final String GROUP_LOGIN = "login";
    private boolean activated;
    private static final Map<String, String> controlGroupByUrlProp = Map.of("host", "host", "server", "server", "database", "db", "folder", "path", "file", "path");

    public void createControl(Composite composite) {
        Label dbLabel;
        Label serverLabel;
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        Composite addrGroup = new Composite(composite, 0);
        addrGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        addrGroup.setLayoutData((Object)gd);
        this.settingsGroup = UIUtils.createControlGroup((Composite)addrGroup, (String)GenericMessages.dialog_connection_general_tab, (int)4, (int)768, (int)0);
        GridLayout gl = new GridLayout(4, false);
        this.settingsGroup.setLayout((Layout)gl);
        SelectionAdapter typeSwitcher = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GenericConnectionPage.this.controlGroupsByUrl.size() > 0) {
                    GenericConnectionPage.this.setupConnectionModeSelection(GenericConnectionPage.this.urlText, GenericConnectionPage.this.typeURLRadio.getSelection(), GenericConnectionPage.this.controlGroupsByUrl);
                }
                GenericConnectionPage.this.saveAndUpdate();
            }
        };
        this.createConnectionModeSwitcher(this.settingsGroup, (SelectionListener)typeSwitcher);
        Label urlLabel = UIUtils.createControlLabel((Composite)this.settingsGroup, (String)GenericMessages.dialog_connection_jdbc_url_);
        urlLabel.setLayoutData((Object)new GridData(128));
        this.urlText = new Text(this.settingsGroup, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 355;
        this.urlText.setLayoutData((Object)gd);
        this.urlText.addModifyListener(e -> this.site.updateButtons());
        this.addControlToGroup(GROUP_URL, new Control[]{urlLabel});
        this.addControlToGroup(GROUP_URL, new Control[]{this.urlText});
        Label hostLabel = new Label(this.settingsGroup, 0);
        hostLabel.setText(GenericMessages.dialog_connection_host_label);
        hostLabel.setLayoutData((Object)new GridData(128));
        this.hostText = new Text(this.settingsGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        this.hostText.addModifyListener(textListener);
        Label portLabel = new Label(this.settingsGroup, 0);
        portLabel.setText(GenericMessages.dialog_connection_port_label);
        portLabel.setLayoutData((Object)new GridData(128));
        this.portText = new Text(this.settingsGroup, 2048);
        gd = new GridData(2);
        gd.widthHint = UIUtils.getFontHeight((Control)this.portText) * 7;
        this.portText.setLayoutData((Object)gd);
        this.portText.addModifyListener(textListener);
        this.addControlToGroup(GROUP_HOST, new Control[]{hostLabel});
        this.addControlToGroup(GROUP_HOST, new Control[]{this.hostText});
        this.addControlToGroup(GROUP_HOST, new Control[]{portLabel});
        this.addControlToGroup(GROUP_HOST, new Control[]{this.portText});
        DBPDriver driver = this.site.getActiveDataSource().getDriver();
        String dbTerm = (String)driver.getDriverParameter("term-server");
        if (CommonUtils.isNotEmpty((String)dbTerm)) {
            serverLabel = UIUtils.createControlLabel((Composite)this.settingsGroup, (String)dbTerm);
        } else {
            serverLabel = new Label(this.settingsGroup, 0);
            serverLabel.setText(GenericMessages.dialog_connection_server_label);
        }
        serverLabel.setLayoutData((Object)new GridData(128));
        this.serverText = new Text(this.settingsGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.serverText.setLayoutData((Object)gd);
        this.serverText.addModifyListener(textListener);
        Control emptyLabel = UIUtils.createEmptyLabel((Composite)this.settingsGroup, (int)2, (int)1);
        this.addControlToGroup(GROUP_SERVER, new Control[]{serverLabel});
        this.addControlToGroup(GROUP_SERVER, new Control[]{this.serverText});
        this.addControlToGroup(GROUP_SERVER, new Control[]{emptyLabel});
        driver = this.site.getActiveDataSource().getDriver();
        dbTerm = (String)driver.getDriverParameter("term-database");
        if (CommonUtils.isNotEmpty((String)dbTerm)) {
            dbLabel = UIUtils.createControlLabel((Composite)this.settingsGroup, (String)dbTerm);
        } else {
            dbLabel = new Label(this.settingsGroup, 0);
            dbLabel.setText(GenericMessages.dialog_connection_database_schema_label);
        }
        dbLabel.setLayoutData((Object)new GridData(128));
        this.dbText = new Text(this.settingsGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.dbText.setLayoutData((Object)gd);
        this.dbText.addModifyListener(textListener);
        emptyLabel = UIUtils.createEmptyLabel((Composite)this.settingsGroup, (int)2, (int)1);
        this.addControlToGroup(GROUP_DB, new Control[]{dbLabel});
        this.addControlToGroup(GROUP_DB, new Control[]{this.dbText});
        this.addControlToGroup(GROUP_DB, new Control[]{emptyLabel});
        Label pathLabel = new Label(this.settingsGroup, 0);
        pathLabel.setText(GenericMessages.dialog_connection_path_label);
        pathLabel.setLayoutData((Object)new GridData(128));
        this.pathText = new Text(this.settingsGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 200;
        gd.horizontalSpan = 2;
        this.pathText.setLayoutData((Object)gd);
        this.pathText.addModifyListener(textListener);
        Composite buttonsPanel = new Composite(this.settingsGroup, 0);
        gl = new GridLayout(1, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        buttonsPanel.setLayout((Layout)gl);
        gd = new GridData(128);
        buttonsPanel.setLayoutData((Object)gd);
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)GenericMessages.dialog_connection_browse_button, null, (String)GenericMessages.dialog_connection_browse_button_tip, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = GenericConnectionPage.this.showDatabaseFileSelectorDialog(4096);
                if (path != null) {
                    GenericConnectionPage.this.pathText.setText(path);
                }
            }
        });
        if (CommonUtils.toBoolean((Object)this.site.getDriver().getDriverParameter("supports-embedded-database-creation"))) {
            ++gl.numColumns;
            UIUtils.createDialogButton((Composite)buttonsPanel, (String)GenericMessages.dialog_connection_create_button, null, (String)GenericMessages.dialog_connection_create_button_tip, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String path = GenericConnectionPage.this.showDatabaseFileSelectorDialog(8192);
                    if (path != null) {
                        GenericConnectionPage.this.pathText.setText(path);
                        if (GenericConnectionPage.this.canCreateEmbeddedDatabase()) {
                            GenericConnectionPage.this.createEmbeddedDatabase();
                        }
                    }
                }
            });
        }
        this.addControlToGroup(GROUP_PATH, new Control[]{pathLabel});
        this.addControlToGroup(GROUP_PATH, new Control[]{this.pathText});
        this.addControlToGroup(GROUP_PATH, new Control[]{buttonsPanel});
        if (this.isAuthEnabled()) {
            this.createAuthPanel(addrGroup, 4);
            this.addControlToGroup(GROUP_LOGIN, new Control[]{this.getAuthPanelComposite()});
        }
        this.createAdvancedSettingsGroup(addrGroup);
        this.createDriverPanel(addrGroup);
        this.setControl((Control)addrGroup);
    }

    @Nullable
    private String showDatabaseFileSelectorDialog(int style) {
        if (this.metaURL.getAvailableProperties().contains("file")) {
            FileDialog dialog = new FileDialog(this.getShell(), 4 | style);
            String text = this.pathText.getText();
            dialog.setFileName(text);
            if (CommonUtils.isNotEmpty((String)text)) {
                try {
                    String directoryPath = IOUtils.getDirectoryPath((String)text);
                    if (CommonUtils.isNotEmpty((String)directoryPath)) {
                        dialog.setFilterPath(directoryPath);
                    }
                }
                catch (InvalidPathException ex) {
                    log.debug((Object)"Can't find directory path", (Throwable)ex);
                }
            }
            dialog.setText(GenericMessages.dialog_connection_db_file_chooser_text);
            return dialog.open();
        }
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 0);
        String curPath = this.pathText.getText();
        File curFolder = new File(curPath);
        if (curFolder.exists()) {
            if (curFolder.isDirectory()) {
                dialog.setFilterPath(curFolder.getAbsolutePath());
            } else {
                dialog.setFilterPath(curFolder.getParentFile().getAbsolutePath());
            }
        }
        dialog.setText(GenericMessages.dialog_connection_db_folder_chooser_text);
        dialog.setMessage(GenericMessages.dialog_connection_db_folder_chooser_message);
        return dialog.open();
    }

    public void createAdvancedSettingsGroup(Composite composite) {
    }

    public void setPortText(String text) {
        this.portText.setText(text);
        this.saveAndUpdate();
    }

    protected void updateDriverInfo(DBPDriver driver) {
        if (!this.isCustom) {
            this.site.getActiveDataSource().getConnectionConfiguration().setUrl(null);
        }
        this.parseSampleURL(driver);
        this.setupConnectionModeSelection(this.urlText, this.isCustomURL(), this.controlGroupsByUrl);
        this.saveAndUpdate();
    }

    public boolean isComplete() {
        if (this.isCustomURL()) {
            return !CommonUtils.isEmpty((String)this.urlText.getText());
        }
        if (this.metaURL == null) {
            return false;
        }
        for (String prop : this.metaURL.getRequiredProperties()) {
            if (this.isConnectionPropertyOptional(prop) || !(prop.equals(GROUP_HOST) && CommonUtils.isEmptyTrimmed((String)this.hostText.getText()) || prop.equals("port") && CommonUtils.isEmptyTrimmed((String)this.portText.getText()) || prop.equals("database") && CommonUtils.isEmptyTrimmed((String)this.dbText.getText())) && (!prop.equals("file") && !prop.equals("folder") || !CommonUtils.isEmptyTrimmed((String)this.pathText.getText()))) continue;
            return false;
        }
        return true;
    }

    protected boolean isConnectionPropertyOptional(String property) {
        return false;
    }

    protected boolean isCustomURL() {
        return this.isCustom || this.typeURLRadio != null && this.typeURLRadio.getSelection();
    }

    public Image getImage() {
        DBPDriver driver = this.getSite().getDriver();
        DBPImage icon = driver.getLogoImage();
        if (icon == null) {
            icon = driver.getIconBig();
        }
        if (icon != null) {
            try {
                Image image = DBeaverIcons.getImage((DBPImage)icon);
                if (image.getImageData().width >= 64) {
                    return image;
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return super.getImage();
    }

    public void loadSettings() {
        boolean useURL;
        super.loadSettings();
        DBPDataSourceContainer dataSource = this.site.getActiveDataSource();
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        this.parseSampleURL(this.site.getDriver());
        boolean bl = useURL = connectionInfo.getConfigurationType() == DBPDriverConfigurationType.URL;
        if (this.controlGroupsByUrl.size() > 0) {
            this.setupConnectionModeSelection(this.urlText, useURL, this.controlGroupsByUrl);
        }
        this.site.updateButtons();
        if (!this.isCustom) {
            if (this.hostText != null) {
                if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                    this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
                } else {
                    this.hostText.setText(CommonUtils.toString((Object)this.site.getDriver().getDefaultHost(), (String)"localhost"));
                }
            }
            if (this.portText != null) {
                if (this.site.isNew() && CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                    this.portText.setText(CommonUtils.notEmpty((String)this.site.getDriver().getDefaultPort()));
                } else if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                    this.portText.setText(connectionInfo.getHostPort());
                }
            }
            if (this.serverText != null) {
                if (this.site.isNew() && CommonUtils.isEmpty((String)connectionInfo.getServerName())) {
                    this.serverText.setText(CommonUtils.notEmpty((String)this.site.getDriver().getDefaultServer()));
                } else {
                    this.serverText.setText(CommonUtils.notEmpty((String)connectionInfo.getServerName()));
                }
            }
            if (this.dbText != null) {
                if (this.site.isNew() && CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                    this.dbText.setText(CommonUtils.notEmpty((String)this.site.getDriver().getDefaultDatabase()));
                } else {
                    this.dbText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
                }
            }
            if (this.pathText != null) {
                this.pathText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
            }
        } else {
            this.hostText.setText("");
            this.portText.setText("");
            this.serverText.setText("");
            this.dbText.setText("");
            this.pathText.setText("");
        }
        if (this.urlText != null) {
            if (CommonUtils.isEmpty((String)connectionInfo.getUrl())) {
                try {
                    this.saveSettings(dataSource);
                }
                catch (Exception e) {
                    this.setMessage(e.getMessage());
                }
            }
            if (this.isCustomURL() && this.typeURLRadio != null && !this.typeURLRadio.isVisible() && CommonUtils.isEmpty((String)connectionInfo.getUrl())) {
                this.urlText.setText(CommonUtils.notEmpty((String)dataSource.getDriver().getSampleURL()));
            } else if (connectionInfo.getUrl() != null) {
                this.urlText.setText(CommonUtils.notEmpty((String)connectionInfo.getUrl()));
            } else {
                this.urlText.setText("");
            }
        }
        this.activated = true;
        UIUtils.asyncExec(() -> {
            if (CommonUtils.isEmpty((String)this.site.getDriver().getSampleURL())) {
                this.urlText.setFocus();
            } else if (this.hostText != null && this.hostText.isVisible()) {
                this.hostText.setFocus();
            } else if (this.serverText != null && this.serverText.isVisible()) {
                this.serverText.setFocus();
            } else if (this.dbText != null && this.dbText.isVisible()) {
                this.dbText.setFocus();
            } else if (this.pathText != null && this.pathText.isVisible()) {
                this.pathText.setFocus();
            }
        });
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        Set properties = this.metaURL == null ? Collections.emptySet() : this.metaURL.getAvailableProperties();
        connectionInfo.setConfigurationType(this.typeURLRadio != null && this.typeURLRadio.getSelection() ? DBPDriverConfigurationType.URL : DBPDriverConfigurationType.MANUAL);
        if (this.hostText != null && properties.contains(GROUP_HOST)) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null && properties.contains("port")) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.serverText != null && properties.contains(GROUP_SERVER)) {
            connectionInfo.setServerName(this.serverText.getText().trim());
        }
        if (this.dbText != null && properties.contains("database")) {
            connectionInfo.setDatabaseName(this.dbText.getText().trim());
        }
        if (this.pathText != null && (properties.contains("folder") || properties.contains("file"))) {
            connectionInfo.setDatabaseName(this.pathText.getText().trim());
        }
        super.saveSettings(dataSource);
        if (this.isCustomURL()) {
            if (this.urlText != null) {
                connectionInfo.setUrl(this.urlText.getText().trim());
            }
        } else if (this.urlText != null && connectionInfo.getUrl() != null) {
            this.urlText.setText(connectionInfo.getUrl());
        }
    }

    private void parseSampleURL(DBPDriver driver) {
        this.metaURL = null;
        boolean useCustomUrl = CommonUtils.isEmpty((String)driver.getSampleURL());
        if (!useCustomUrl) {
            boolean isSampleUrlUsable;
            try {
                this.metaURL = DatabaseURL.parseSampleURL((String)driver.getSampleURL());
            }
            catch (DBException e) {
                this.setErrorMessage(e.getMessage());
            }
            Set properties = this.metaURL.getAvailableProperties();
            boolean bl = isSampleUrlUsable = properties.contains(GROUP_HOST) || properties.contains("database") || properties.contains(GROUP_SERVER) || properties.contains("folder") || properties.contains("file");
            if (isSampleUrlUsable) {
                this.isCustom = false;
                this.showControlGroup(GROUP_HOST, properties.contains(GROUP_HOST));
                this.showControlGroup(GROUP_SERVER, properties.contains(GROUP_SERVER));
                this.showControlGroup(GROUP_DB, properties.contains("database"));
                this.showControlGroup(GROUP_PATH, properties.contains("folder") || properties.contains("file"));
                this.showControlGroup("connectionMode", true);
                this.urlText.setEditable(false);
                this.controlGroupsByUrl = properties.stream().map(controlGroupByUrlProp::get).collect(Collectors.toSet());
            } else {
                useCustomUrl = true;
            }
        }
        if (useCustomUrl) {
            this.isCustom = true;
            this.showControlGroup(GROUP_HOST, false);
            this.showControlGroup(GROUP_SERVER, false);
            this.showControlGroup(GROUP_DB, false);
            this.showControlGroup(GROUP_PATH, false);
            this.showControlGroup("connectionMode", false);
            this.urlText.setEditable(true);
            this.controlGroupsByUrl = Collections.emptyList();
        }
        UIUtils.fixReadonlyTextBackground((Text)this.urlText);
        this.showControlGroup(GROUP_LOGIN, !driver.isAnonymousAccess());
        this.settingsGroup.getParent().layout();
    }

    private boolean canCreateEmbeddedDatabase() {
        String param = CommonUtils.toString((Object)this.site.getDriver().getDriverParameter("create-url-param"));
        return !CommonUtils.isEmpty((String)param) && !CommonUtils.isEmptyTrimmed((String)this.pathText.getText());
    }

    private void createEmbeddedDatabase() {
        String paramCreate = CommonUtils.toString((Object)this.site.getDriver().getDriverParameter("create-url-param"));
        DataSourceDescriptor dataSource = (DataSourceDescriptor)this.site.getActiveDataSource();
        DataSourceDescriptor testDataSource = (DataSourceDescriptor)this.site.getDataSourceRegistry().createDataSource(dataSource.getId(), dataSource.getDriver(), new DBPConnectionConfiguration(dataSource.getConnectionConfiguration()));
        this.saveSettings((DBPDataSourceContainer)testDataSource);
        DBPConnectionConfiguration cfg = testDataSource.getConnectionConfiguration();
        cfg.setDatabaseName(cfg.getDatabaseName() + paramCreate);
        String databaseName = cfg.getDatabaseName();
        testDataSource.setName(databaseName);
        if (!UIUtils.confirmAction((Shell)this.getShell(), (String)"Create Database", (String)("Are you sure you want to create database '" + databaseName + "'?"))) {
            testDataSource.dispose();
            return;
        }
        try {
            this.site.getRunnableContext().run(true, true, monitor -> {
                try {
                    this.createEmbeddedDatabase(monitor, testDataSource);
                }
                catch (DBException e1) {
                    throw new InvocationTargetException(e1);
                }
            });
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Database Create", (String)("Database '" + databaseName + "' created!"));
        }
        catch (InvocationTargetException e1) {
            DBWorkbench.getPlatformUI().showError("Create database", "Error creating database", e1.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }

    private void createEmbeddedDatabase(DBRProgressMonitor monitor, DataSourceDescriptor testDataSource) throws DBException {
        try {
            testDataSource.connect(monitor, true, true);
            testDataSource.disconnect(monitor);
        }
        finally {
            testDataSource.dispose();
        }
    }

    private void saveAndUpdate() {
        this.saveSettings(this.site.getActiveDataSource());
        this.site.updateButtons();
    }

    private void showControlGroup(String group, boolean show) {
        Set controlList = (Set)this.propGroupMap.get(group);
        if (controlList != null) {
            for (Control control : controlList) {
                Object gd = control.getLayoutData();
                if (gd == null) {
                    gd = new GridData(1);
                    control.setLayoutData(gd);
                }
                if (gd instanceof GridData) {
                    ((GridData)gd).exclude = !show;
                }
                control.setVisible(show);
            }
        }
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

