/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMDataSourceInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMetaObjectType;

public class QMMDataSourceConnectErrorInfo
extends QMMObject
implements QMMDataSourceInfo {
    @NotNull
    private final String containerId;
    @NotNull
    private final String containerName;
    @NotNull
    private final String driverId;
    @Nullable
    private final String connectionUrl;
    @NotNull
    private final String errorType;
    @Nullable
    private final String errorMessage;

    public QMMDataSourceConnectErrorInfo(@NotNull DBPDataSourceContainer container, @NotNull String errorType, @Nullable String errorMessage) {
        super(QMMetaObjectType.CONNECTION_ERROR_INFO);
        this.containerId = container.getId();
        this.containerName = container.getName();
        this.driverId = container.getDriver().getId();
        this.connectionUrl = container.getConnectionConfiguration().getUrl();
        this.errorType = errorType;
        this.errorMessage = errorMessage;
    }

    @Override
    @NotNull
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    @NotNull
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    @NotNull
    public String getDriverId() {
        return this.driverId;
    }

    @Override
    @Nullable
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @NotNull
    public String getErrorType() {
        return this.errorType;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    public QMMConnectionInfo getConnection() {
        return null;
    }
}

