/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.firebird.FireBirdUtils;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdDataSource;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdDataTypeCache;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdDatabaseTrigger;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdProcedure;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdSequence;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTable;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTableBase;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTableColumn;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTableTrigger;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTrigger;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTriggerType;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdView;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class FireBirdMetaModel
extends GenericMetaModel {
    private static final int OBJECT_NAME_LENGTH = 63;
    private Pattern ERROR_POSITION_PATTERN = Pattern.compile(" line ([0-9]+), column ([0-9]+)");

    public GenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new FireBirdDataSource(monitor, container, this);
    }

    public FireBirdDataTypeCache createDataTypeCache(@NotNull GenericStructContainer container) {
        return new FireBirdDataTypeCache(container);
    }

    public String getViewDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericView sourceObject, @NotNull Map<String, Object> options) throws DBException {
        return FireBirdUtils.getViewSource(monitor, (GenericTableBase)sourceObject);
    }

    public boolean supportsEqualFunctionsAndProceduresNames() {
        return true;
    }

    public String getProcedureDDL(DBRProgressMonitor monitor, GenericProcedure sourceObject) throws DBException {
        return FireBirdUtils.getProcedureSource(monitor, sourceObject);
    }

    public GenericProcedure createProcedureImpl(GenericStructContainer container, String procedureName, String specificName, String remarks, DBSProcedureType procedureType, GenericFunctionResultType functionResultType) {
        return new FireBirdProcedure(container, procedureName, specificName, remarks, procedureType, functionResultType);
    }

    public boolean supportsSequences(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public JDBCStatement prepareSequencesLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
        return session.prepareStatement("SELECT * FROM RDB$GENERATORS");
    }

    public GenericSequence createSequenceImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) {
        String name = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$GENERATOR_NAME");
        if (CommonUtils.isEmpty((String)name)) {
            return null;
        }
        String description = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$DESCRIPTION");
        boolean isSystem = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"RDB$SYSTEM_FLAG");
        return new FireBirdSequence(container, name, description, null, 0, -1, 1, isSystem);
    }

    public boolean supportsTriggers(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public JDBCStatement prepareTableTriggersLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @Nullable GenericTableBase table) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT RDB$TRIGGER_NAME AS TRIGGER_NAME, RDB$RELATION_NAME AS OWNER, T.* FROM RDB$TRIGGERS T\nWHERE RDB$RELATION_NAME" + (table == null ? " IS NOT NULL" : "=?"));
        if (table != null) {
            dbStat.setString(1, table.getName());
        }
        return dbStat;
    }

    public GenericTrigger createTableTriggerImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull GenericTableBase parent, String triggerName, @NotNull JDBCResultSet dbResult) throws DBException {
        if (CommonUtils.isEmpty((String)triggerName)) {
            triggerName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$TRIGGER_NAME");
        }
        if (triggerName == null) {
            return null;
        }
        int sequence = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$TRIGGER_SEQUENCE");
        int type = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$TRIGGER_TYPE");
        String description = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$DESCRIPTION");
        int systemFlag = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$SYSTEM_FLAG");
        boolean isSystem = systemFlag > 0;
        return new FireBirdTableTrigger(parent, triggerName, description, FireBirdTriggerType.getByType(type), sequence, isSystem);
    }

    public boolean supportsDatabaseTriggers(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public JDBCStatement prepareContainerTriggersLoadStatement(@NotNull JDBCSession session, @Nullable GenericStructContainer forParent) throws SQLException {
        return session.prepareStatement("SELECT * FROM RDB$TRIGGERS WHERE RDB$RELATION_NAME IS NULL");
    }

    public GenericTrigger createContainerTriggerImpl(@NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) throws DBException {
        String name = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$TRIGGER_NAME");
        if (name == null) {
            return null;
        }
        int sequence = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$TRIGGER_SEQUENCE");
        int type = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$TRIGGER_TYPE");
        String description = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$DESCRIPTION");
        int systemFlag = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$SYSTEM_FLAG");
        boolean isSystem = true;
        if (systemFlag == 0) {
            isSystem = false;
        }
        return new FireBirdDatabaseTrigger(container, name, description, FireBirdTriggerType.getByType(type), sequence, isSystem);
    }

    /*
     * Loose catch block
     */
    public List<GenericTrigger> loadTriggers(DBRProgressMonitor monitor, @NotNull GenericStructContainer container, @Nullable GenericTableBase table) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read triggers");){
                ArrayList<GenericTrigger> arrayList;
                JDBCPreparedStatement dbStat;
                Throwable throwable2;
                block33: {
                    throwable2 = null;
                    Object var8_12 = null;
                    dbStat = session.prepareStatement("SELECT * FROM RDB$TRIGGERS\nWHERE RDB$RELATION_NAME" + (table == null ? " IS NULL" : "=?"));
                    if (table != null) {
                        dbStat.setString(1, table.getName());
                    }
                    ArrayList<GenericTrigger> result = new ArrayList<GenericTrigger>();
                    Throwable throwable3 = null;
                    Object var12_18 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String name = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$TRIGGER_NAME");
                            if (name == null) continue;
                            int sequence = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$TRIGGER_SEQUENCE");
                            int type = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$TRIGGER_TYPE");
                            String description = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$DESCRIPTION");
                            int systemFlag = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$SYSTEM_FLAG");
                            boolean isSystem = systemFlag > 0;
                            FireBirdTableTrigger trigger = new FireBirdTableTrigger(table, name, description, FireBirdTriggerType.getByType(type), sequence, isSystem);
                            result.add(trigger);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    arrayList = result;
                    if (dbStat == null) break block33;
                    dbStat.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable5) {
                        try {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, (DBPDataSource)container.getDataSource());
        }
    }

    public String getTriggerDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTrigger trigger) throws DBException {
        return FireBirdUtils.getTriggerSource(monitor, (FireBirdTrigger)trigger);
    }

    public DBPErrorAssistant.ErrorPosition getErrorPosition(@NotNull Throwable error) {
        Matcher matcher;
        String message = error.getMessage();
        if (!CommonUtils.isEmpty((String)message) && (matcher = this.ERROR_POSITION_PATTERN.matcher(message)).find()) {
            DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
            pos.line = Integer.parseInt(matcher.group(1)) - 1;
            pos.position = Integer.parseInt(matcher.group(2)) - 1;
            return pos;
        }
        return null;
    }

    public boolean isTrimObjectNames() {
        return true;
    }

    public boolean isSystemTable(GenericTableBase table) {
        String tableName = table.getName();
        return (tableName = tableName.toUpperCase(Locale.ENGLISH)).startsWith("RDB$") || tableName.startsWith("MON$");
    }

    public JDBCStatement prepareTableLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase object, @Nullable String objectName) throws SQLException {
        Object sql = "SELECT * FROM RDB$RELATIONS";
        sql = object == null && objectName == null ? (String)sql + "\nORDER BY RDB$RELATION_NAME" : (String)sql + "\nWHERE RDB$RELATION_NAME=?";
        JDBCPreparedStatement dbStat = session.prepareStatement((String)sql);
        if (object != null || objectName != null) {
            dbStat.setString(1, object != null ? object.getName() : objectName);
        }
        return dbStat;
    }

    public GenericTableBase createTableOrViewImpl(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        if (tableType != null && this.isView(tableType)) {
            return new FireBirdView(container, tableName, tableType, dbResult);
        }
        return new FireBirdTable(container, tableName, tableType, dbResult);
    }

    public GenericTableBase createTableImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull GenericMetaObject tableObject, @NotNull JDBCResultSet dbResult) {
        FireBirdTableBase table;
        String relationName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$RELATION_NAME");
        boolean isSystem = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$SYSTEM_FLAG") != 0;
        int relType = FireBirdMetaModel.getRelationType(dbResult);
        if (relType == 1) {
            table = new FireBirdView(owner, relationName, isSystem ? "SYSTEM VIEW" : "VIEW", dbResult);
        } else {
            table = new FireBirdTable(owner, relationName, switch (relType) {
                case 2 -> "EXTERNAL TABLE";
                case 3 -> "MONITORING TABLE";
                case 4 -> "CONNECTION-LEVEL GTT";
                case 5 -> "TRANSACTION-LEVEL GTT";
                default -> isSystem ? "SYSTEM TABLE" : "TABLE";
            }, dbResult);
        }
        table.setPersisted(true);
        table.setSystem(isSystem);
        table.setDescription(JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$DESCRIPTION"));
        return table;
    }

    private static int getRelationType(@NotNull JDBCResultSet dbResult) {
        try {
            Integer i = (Integer)dbResult.getObject("RDB$RELATION_TYPE", Integer.class);
            if (i == null) {
                return FireBirdMetaModel.getRelTypeFromViewBLR(dbResult);
            }
            return i;
        }
        catch (SQLException sQLException) {
            return FireBirdMetaModel.getRelTypeFromViewBLR(dbResult);
        }
    }

    private static int getRelTypeFromViewBLR(@NotNull JDBCResultSet dbResult) {
        return JDBCUtils.safeGetBytes((ResultSet)dbResult, (String)"RDB$VIEW_BLR") == null ? 0 : 1;
    }

    public boolean isTableCommentEditable() {
        return true;
    }

    public GenericTableColumn createTableColumnImpl(@NotNull DBRProgressMonitor monitor, JDBCResultSet dbResult, @NotNull GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPos, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) throws DBException {
        return new FireBirdTableColumn(monitor, dbResult, table, columnName, typeName, valueType, sourceType, ordinalPos, columnSize, charLength, scale, precision, radix, notNull, remarks, defaultValue, autoIncrement, autoGenerated);
    }

    public String getAutoIncrementClause(GenericTableColumn column) {
        GenericDataSource dataSource = column.getDataSource();
        if (dataSource.isServerVersionAtLeast(3, 0)) {
            return "GENERATED BY DEFAULT AS IDENTITY";
        }
        return null;
    }

    public JDBCStatement prepareUniqueConstraintsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forParent) throws SQLException {
        return session.prepareStatement("select RC.RDB$RELATION_NAME TABLE_NAME,ISGMT.RDB$FIELD_NAME as COLUMN_NAME,CAST((ISGMT.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ,RC.RDB$CONSTRAINT_NAME as PK_NAME,RC.RDB$CONSTRAINT_TYPE as CONSTRAINT_TYPE FROM RDB$RELATION_CONSTRAINTS RC INNER JOIN RDB$INDEX_SEGMENTS ISGMT ON RC.RDB$INDEX_NAME = ISGMT.RDB$INDEX_NAME where RC.RDB$CONSTRAINT_TYPE IN ('PRIMARY KEY','UNIQUE') " + (String)(forParent == null ? "" : "AND RC.RDB$RELATION_NAME = '" + forParent.getName()) + "' ORDER BY ISGMT.RDB$FIELD_NAME ");
    }

    public DBSEntityConstraintType getUniqueConstraintType(JDBCResultSet dbResult) throws DBException, SQLException {
        String constraintType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_TYPE");
        return "PRIMARY KEY".equals(constraintType) ? DBSEntityConstraintType.PRIMARY_KEY : DBSEntityConstraintType.UNIQUE_KEY;
    }

    public boolean supportsUniqueKeys() {
        return true;
    }
}

