Example of illegal code:

```ada
X : Integer with Volatile, Async_Readers, Async_Writers;

function F return Integer is
   Tmp : constant Integer := X; -- error: read volatile variable in function
begin
   return Tmp;
end F;
```

This error is issued on functions which may read volatile variables. This
side-effect is not allowed in regular functions in SPARK, as this could lead to
different behaviors depending on the choice made by the compiler in the order
of evaluation of sub-expressions.

The fix is to mark the function as volatile with the aspect
`Volatile_Function`:

```ada
function F return Integer
  with Volatile_Function
is
   ...
```

As a result, calls to the function are subject to the same restrictions as
reads of volatile variables. They can only occur in a restricted set of
expressions.
