// Code generated by go-swagger; DO NOT EDIT.

package iam_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// IamServiceGetCurrentUserPrincipalReader is a Reader for the IamServiceGetCurrentUserPrincipal structure.
type IamServiceGetCurrentUserPrincipalReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IamServiceGetCurrentUserPrincipalReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIamServiceGetCurrentUserPrincipalOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIamServiceGetCurrentUserPrincipalDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIamServiceGetCurrentUserPrincipalOK creates a IamServiceGetCurrentUserPrincipalOK with default headers values
func NewIamServiceGetCurrentUserPrincipalOK() *IamServiceGetCurrentUserPrincipalOK {
	return &IamServiceGetCurrentUserPrincipalOK{}
}

/*
IamServiceGetCurrentUserPrincipalOK describes a response with status code 200, with default header values.

A successful response.
*/
type IamServiceGetCurrentUserPrincipalOK struct {
	Payload *models.HashicorpCloudIamGetCurrentUserPrincipalResponse
}

// IsSuccess returns true when this iam service get current user principal o k response has a 2xx status code
func (o *IamServiceGetCurrentUserPrincipalOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this iam service get current user principal o k response has a 3xx status code
func (o *IamServiceGetCurrentUserPrincipalOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this iam service get current user principal o k response has a 4xx status code
func (o *IamServiceGetCurrentUserPrincipalOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this iam service get current user principal o k response has a 5xx status code
func (o *IamServiceGetCurrentUserPrincipalOK) IsServerError() bool {
	return false
}

// IsCode returns true when this iam service get current user principal o k response a status code equal to that given
func (o *IamServiceGetCurrentUserPrincipalOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the iam service get current user principal o k response
func (o *IamServiceGetCurrentUserPrincipalOK) Code() int {
	return 200
}

func (o *IamServiceGetCurrentUserPrincipalOK) Error() string {
	return fmt.Sprintf("[GET /iam/2019-12-10/me][%d] iamServiceGetCurrentUserPrincipalOK  %+v", 200, o.Payload)
}

func (o *IamServiceGetCurrentUserPrincipalOK) String() string {
	return fmt.Sprintf("[GET /iam/2019-12-10/me][%d] iamServiceGetCurrentUserPrincipalOK  %+v", 200, o.Payload)
}

func (o *IamServiceGetCurrentUserPrincipalOK) GetPayload() *models.HashicorpCloudIamGetCurrentUserPrincipalResponse {
	return o.Payload
}

func (o *IamServiceGetCurrentUserPrincipalOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamGetCurrentUserPrincipalResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIamServiceGetCurrentUserPrincipalDefault creates a IamServiceGetCurrentUserPrincipalDefault with default headers values
func NewIamServiceGetCurrentUserPrincipalDefault(code int) *IamServiceGetCurrentUserPrincipalDefault {
	return &IamServiceGetCurrentUserPrincipalDefault{
		_statusCode: code,
	}
}

/*
IamServiceGetCurrentUserPrincipalDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type IamServiceGetCurrentUserPrincipalDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this iam service get current user principal default response has a 2xx status code
func (o *IamServiceGetCurrentUserPrincipalDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this iam service get current user principal default response has a 3xx status code
func (o *IamServiceGetCurrentUserPrincipalDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this iam service get current user principal default response has a 4xx status code
func (o *IamServiceGetCurrentUserPrincipalDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this iam service get current user principal default response has a 5xx status code
func (o *IamServiceGetCurrentUserPrincipalDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this iam service get current user principal default response a status code equal to that given
func (o *IamServiceGetCurrentUserPrincipalDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the iam service get current user principal default response
func (o *IamServiceGetCurrentUserPrincipalDefault) Code() int {
	return o._statusCode
}

func (o *IamServiceGetCurrentUserPrincipalDefault) Error() string {
	return fmt.Sprintf("[GET /iam/2019-12-10/me][%d] IamService_GetCurrentUserPrincipal default  %+v", o._statusCode, o.Payload)
}

func (o *IamServiceGetCurrentUserPrincipalDefault) String() string {
	return fmt.Sprintf("[GET /iam/2019-12-10/me][%d] IamService_GetCurrentUserPrincipal default  %+v", o._statusCode, o.Payload)
}

func (o *IamServiceGetCurrentUserPrincipalDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *IamServiceGetCurrentUserPrincipalDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
