/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core;

public interface RefCounted {
    public static final RefCounted ALWAYS_REFERENCED;

    public void incRef();

    public boolean tryIncRef();

    public boolean decRef();

    public boolean hasReferences();

    default public void mustIncRef() {
        if (this.tryIncRef()) {
            return;
        }
        if (!2.$assertionsDisabled) {
            throw new AssertionError((Object)"already closed, can't increment ref count");
        }
        this.incRef();
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        ALWAYS_REFERENCED = new RefCounted(){

            @Override
            public void incRef() {
            }

            @Override
            public boolean tryIncRef() {
                return true;
            }

            @Override
            public boolean decRef() {
                return false;
            }

            @Override
            public boolean hasReferences() {
                return true;
            }
        };
    }
}

