/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.operator.topn.ResultBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;

public class ResultBuilderForNull
implements ResultBuilder {
    private final BlockFactory blockFactory;
    private int positions;

    public ResultBuilderForNull(BlockFactory blockFactory) {
        this.blockFactory = blockFactory;
    }

    @Override
    public void decodeKey(BytesRef keys) {
        throw new AssertionError((Object)"somehow got a value for a null key");
    }

    @Override
    public void decodeValue(BytesRef values) {
        int size = TopNEncoder.DEFAULT_UNSORTABLE.decodeVInt(values);
        if (size != 0) {
            throw new IllegalArgumentException("null columns should always have 0 entries");
        }
        ++this.positions;
    }

    @Override
    public Block build() {
        return this.blockFactory.newConstantNullBlock(this.positions);
    }

    public String toString() {
        return "ValueExtractorForNull";
    }

    public void close() {
    }
}

