/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import java.util.Locale;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.KeyExtractor;
import org.elasticsearch.compute.operator.topn.TopNEncoder;

abstract class KeyExtractorForFloat
implements KeyExtractor {
    private final byte nul;
    private final byte nonNul;

    static KeyExtractorForFloat extractorFor(TopNEncoder encoder, boolean ascending, byte nul, byte nonNul, FloatBlock block) {
        FloatVector v = block.asVector();
        if (v != null) {
            return new FromVector(encoder, nul, nonNul, v);
        }
        if (ascending) {
            return block.mvSortedAscending() ? new MinFromAscendingBlock(encoder, nul, nonNul, block) : new MinFromUnorderedBlock(encoder, nul, nonNul, block);
        }
        return block.mvSortedAscending() ? new MaxFromAscendingBlock(encoder, nul, nonNul, block) : new MaxFromUnorderedBlock(encoder, nul, nonNul, block);
    }

    KeyExtractorForFloat(TopNEncoder encoder, byte nul, byte nonNul) {
        assert (encoder == TopNEncoder.DEFAULT_SORTABLE);
        this.nul = nul;
        this.nonNul = nonNul;
    }

    protected final int nonNul(BreakingBytesRefBuilder key, float value) {
        key.append(this.nonNul);
        TopNEncoder.DEFAULT_SORTABLE.encodeFloat(value, key);
        return 5;
    }

    protected final int nul(BreakingBytesRefBuilder key) {
        key.append(this.nul);
        return 1;
    }

    public final String toString() {
        return String.format(Locale.ROOT, "KeyExtractorForFloat%s(%s, %s)", this.getClass().getSimpleName(), this.nul, this.nonNul);
    }

    static class FromVector
    extends KeyExtractorForFloat {
        private final FloatVector vector;

        FromVector(TopNEncoder encoder, byte nul, byte nonNul, FloatVector vector) {
            super(encoder, nul, nonNul);
            this.vector = vector;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            return this.nonNul(key, this.vector.getFloat(position));
        }
    }

    static class MinFromAscendingBlock
    extends KeyExtractorForFloat {
        private final FloatBlock block;

        MinFromAscendingBlock(TopNEncoder encoder, byte nul, byte nonNul, FloatBlock block) {
            super(encoder, nul, nonNul);
            this.block = block;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            if (this.block.isNull(position)) {
                return this.nul(key);
            }
            return this.nonNul(key, this.block.getFloat(this.block.getFirstValueIndex(position)));
        }
    }

    static class MinFromUnorderedBlock
    extends KeyExtractorForFloat {
        private final FloatBlock block;

        MinFromUnorderedBlock(TopNEncoder encoder, byte nul, byte nonNul, FloatBlock block) {
            super(encoder, nul, nonNul);
            this.block = block;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            int size = this.block.getValueCount(position);
            if (size == 0) {
                return this.nul(key);
            }
            int start = this.block.getFirstValueIndex(position);
            int end = start + size;
            float min = this.block.getFloat(start);
            for (int i = start + 1; i < end; ++i) {
                min = Math.min(min, this.block.getFloat(i));
            }
            return this.nonNul(key, min);
        }
    }

    static class MaxFromAscendingBlock
    extends KeyExtractorForFloat {
        private final FloatBlock block;

        MaxFromAscendingBlock(TopNEncoder encoder, byte nul, byte nonNul, FloatBlock block) {
            super(encoder, nul, nonNul);
            this.block = block;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            if (this.block.isNull(position)) {
                return this.nul(key);
            }
            return this.nonNul(key, this.block.getFloat(this.block.getFirstValueIndex(position) + this.block.getValueCount(position) - 1));
        }
    }

    static class MaxFromUnorderedBlock
    extends KeyExtractorForFloat {
        private final FloatBlock block;

        MaxFromUnorderedBlock(TopNEncoder encoder, byte nul, byte nonNul, FloatBlock block) {
            super(encoder, nul, nonNul);
            this.block = block;
        }

        @Override
        public int writeKey(BreakingBytesRefBuilder key, int position) {
            int size = this.block.getValueCount(position);
            if (size == 0) {
                return this.nul(key);
            }
            int start = this.block.getFirstValueIndex(position);
            int end = start + size;
            float max = this.block.getFloat(start);
            for (int i = start + 1; i < end; ++i) {
                max = Math.max(max, this.block.getFloat(i));
            }
            return this.nonNul(key, max);
        }
    }
}

