/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.SortAgnostic;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public class MvExpand
extends UnaryPlan
implements TelemetryAware,
SortAgnostic {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "MvExpand", MvExpand::new);
    private final NamedExpression target;
    private final Attribute expanded;
    private List<Attribute> output;

    public MvExpand(Source source, LogicalPlan child, NamedExpression target, Attribute expanded) {
        super(source, child);
        this.target = target;
        this.expanded = expanded;
    }

    private MvExpand(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), (NamedExpression)in.readNamedWriteable(NamedExpression.class), (Attribute)in.readNamedWriteable(Attribute.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeNamedWriteable((NamedWriteable)this.target());
        out.writeNamedWriteable((NamedWriteable)this.expanded());
    }

    public String getWriteableName() {
        return MvExpand.ENTRY.name;
    }

    public static List<Attribute> calculateOutput(List<Attribute> input, NamedExpression target, Attribute expanded) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        for (Attribute attribute : input) {
            if (attribute.name().equals(target.name())) {
                result.add(expanded);
                continue;
            }
            result.add(attribute);
        }
        return result;
    }

    public NamedExpression target() {
        return this.target;
    }

    public Attribute expanded() {
        return this.expanded;
    }

    @Override
    protected AttributeSet computeReferences() {
        return this.target.references();
    }

    @Override
    public String telemetryLabel() {
        return "MV_EXPAND";
    }

    @Override
    public boolean expressionsResolved() {
        return this.target.resolved();
    }

    @Override
    public MvExpand replaceChild(LogicalPlan newChild) {
        return new MvExpand(this.source(), newChild, this.target, this.expanded);
    }

    @Override
    public List<Attribute> output() {
        if (this.output == null) {
            this.output = MvExpand.calculateOutput(this.child().output(), this.target, this.expanded);
        }
        return this.output;
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, MvExpand::new, (Object)((Object)this.child()), (Object)this.target, (Object)this.expanded);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.target, this.expanded);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        MvExpand other = (MvExpand)obj;
        return Objects.equals(this.target, other.target) && Objects.equals(this.expanded, other.expanded);
    }
}

