/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.nulls;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.Negatable;
import org.elasticsearch.xpack.esql.core.querydsl.query.ExistsQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.NotQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public class IsNull
extends UnaryScalarFunction
implements Negatable<UnaryScalarFunction>,
TranslationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "IsNull", IsNull::new);

    public IsNull(Source source, Expression field) {
        super(source, field);
    }

    private IsNull(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return IsNull.ENTRY.name;
    }

    protected NodeInfo<IsNull> info() {
        return NodeInfo.create((Node)this, IsNull::new, (Object)this.field());
    }

    protected IsNull replaceChild(Expression newChild) {
        return new IsNull(this.source(), newChild);
    }

    public Object fold(FoldContext ctx) {
        return DataType.isNull((DataType)this.field().dataType()) || this.field().fold(ctx) == null;
    }

    public Nullability nullable() {
        return Nullability.FALSE;
    }

    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    public UnaryScalarFunction negate() {
        return new IsNotNull(this.source(), this.field());
    }

    @Override
    public boolean translatable(LucenePushdownPredicates pushdownPredicates) {
        return IsNull.isTranslatable(this.field(), pushdownPredicates);
    }

    protected static boolean isTranslatable(Expression field, LucenePushdownPredicates pushdownPredicates) {
        return LucenePushdownPredicates.isPushableTextFieldAttribute(field) || pushdownPredicates.isPushableFieldAttribute(field);
    }

    @Override
    public Query asQuery(TranslatorHandler handler) {
        return new NotQuery(this.source(), (Query)new ExistsQuery(this.source(), handler.nameOf(this.field())));
    }
}

