/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix.tree;

import java.text.ParseException;
import java.util.Map;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.PackedQuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.QuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.S2PrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.Version;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceUtils;

public abstract class SpatialPrefixTreeFactory {
    private static final double DEFAULT_GEO_MAX_DETAIL_KM = 0.001;
    public static final String PREFIX_TREE = "prefixTree";
    public static final String MAX_LEVELS = "maxLevels";
    public static final String MAX_DIST_ERR = "maxDistErr";
    public static final String VERSION = "version";
    protected Map<String, String> args;
    protected SpatialContext ctx;
    protected Integer maxLevels;
    private Version version;

    public static SpatialPrefixTree makeSPT(Map<String, String> args, ClassLoader classLoader, SpatialContext ctx) {
        SpatialPrefixTreeFactory instance;
        String cname = args.get(PREFIX_TREE);
        if (cname == null) {
            String string = cname = ctx.isGeo() ? "geohash" : "quad";
        }
        if ("geohash".equalsIgnoreCase(cname)) {
            instance = new GeohashPrefixTree.Factory();
        } else if ("quad".equalsIgnoreCase(cname)) {
            instance = new QuadPrefixTree.Factory();
        } else if ("packedQuad".equalsIgnoreCase(cname)) {
            instance = new PackedQuadPrefixTree.Factory();
        } else if ("s2".equalsIgnoreCase(cname)) {
            instance = new S2PrefixTree.Factory();
        } else {
            try {
                Class<?> c = classLoader.loadClass(cname);
                instance = (SpatialPrefixTreeFactory)c.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        instance.init(args, ctx);
        return instance.newSPT();
    }

    protected void init(Map<String, String> args, SpatialContext ctx) {
        this.args = args;
        this.ctx = ctx;
        this.initVersion();
        this.initMaxLevels();
    }

    protected void initVersion() {
        String versionStr = this.args.get(VERSION);
        try {
            this.setVersion(versionStr == null ? Version.LATEST : Version.parseLeniently((String)versionStr));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    protected void initMaxLevels() {
        double degrees;
        String mlStr = this.args.get(MAX_LEVELS);
        if (mlStr != null) {
            this.maxLevels = Integer.valueOf(mlStr);
            return;
        }
        String maxDetailDistStr = this.args.get(MAX_DIST_ERR);
        if (maxDetailDistStr == null) {
            if (!this.ctx.isGeo()) {
                return;
            }
            degrees = DistanceUtils.dist2Degrees((double)0.001, (double)6371.0087714);
        } else {
            degrees = Double.parseDouble(maxDetailDistStr);
        }
        this.maxLevels = this.getLevelForDistance(degrees);
    }

    public void setVersion(Version v) {
        this.version = v;
    }

    public Version getVersion() {
        return this.version;
    }

    protected abstract int getLevelForDistance(double var1);

    protected abstract SpatialPrefixTree newSPT();
}

