/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

public abstract class CharArraySegment
implements CharSequence {
    private final char[] myArray;
    int end;
    int start;

    public static CharArraySegment valueOf(char[] array) {
        return new RootSegment(array, 0, array.length);
    }

    public static CharArraySegment valueOf(char[] array, int start, int end) {
        return new RootSegment(array, start, end);
    }

    CharArraySegment(char[] array, int start, int end) {
        this.myArray = array;
        this.start = start;
        this.end = end;
    }

    CharArraySegment(CharArraySegment parent, int start, int end) {
        this.myArray = parent.getArray();
        this.start = start;
        this.end = end;
    }

    @Override
    public final char charAt(int index) {
        return this.myArray[this.start() + index];
    }

    @Override
    public final int length() {
        return this.end - this.start;
    }

    @Override
    public final CharArraySegment subSequence(int start, int end) {
        return new Subsegment(this, start, end);
    }

    @Override
    public final String toString() {
        return new String(this.myArray, this.start(), this.length());
    }

    final char[] getArray() {
        return this.myArray;
    }

    abstract int start();

    static final class Subsegment
    extends CharArraySegment {
        private final CharArraySegment myParent;

        Subsegment(CharArraySegment parent, int start, int end) {
            super(parent, start, end);
            this.myParent = parent;
        }

        @Override
        int start() {
            return this.myParent.start() + this.start;
        }
    }

    static final class RootSegment
    extends CharArraySegment {
        RootSegment(char[] array, int start, int end) {
            super(array, start, end);
        }

        @Override
        int start() {
            return this.start;
        }
    }
}

