/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.grok;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;

public class PatternBank {
    public static final PatternBank EMPTY = new PatternBank(Map.of());
    private final Map<String, String> bank;

    public PatternBank(Map<String, String> bank) {
        Objects.requireNonNull(bank, "bank must not be null");
        PatternBank.forbidCircularReferences(bank);
        this.bank = Collections.unmodifiableMap(new LinkedHashMap<String, String>(bank));
    }

    public String get(String patternName) {
        return this.bank.get(patternName);
    }

    public Map<String, String> bank() {
        return this.bank;
    }

    public PatternBank extendWith(Map<String, String> extraPatterns) {
        if (extraPatterns == null || extraPatterns.isEmpty()) {
            return this;
        }
        LinkedHashMap<String, String> extendedBank = new LinkedHashMap<String, String>(this.bank);
        extendedBank.putAll(extraPatterns);
        return new PatternBank(extendedBank);
    }

    static void forbidCircularReferences(Map<String, String> bank) {
        HashSet allVisitedNodes = new HashSet();
        HashSet<String> nodesVisitedMoreThanOnceInAPath = new HashSet<String>();
        for (String traversalStartNode : bank.keySet()) {
            if (!nodesVisitedMoreThanOnceInAPath.contains(traversalStartNode) && allVisitedNodes.contains(traversalStartNode)) continue;
            LinkedHashSet<String> visitedFromThisStartNode = new LinkedHashSet<String>();
            ArrayDeque<String[]> stack = new ArrayDeque<String[]>();
            stack.push(new String[]{traversalStartNode});
            boolean unwinding = false;
            while (!stack.isEmpty()) {
                String[] currentLevel = (String[])stack.peek();
                int firstNonNullIndex = PatternBank.findFirstNonNull(currentLevel);
                String node = currentLevel[firstNonNullIndex];
                boolean endOfThisPath = false;
                if (unwinding) {
                    endOfThisPath = true;
                } else {
                    if (traversalStartNode.equals(node) && stack.size() > 1) {
                        ArrayDeque<String> reversedPath = new ArrayDeque<String>();
                        for (String[] level : stack) {
                            reversedPath.push(level[PatternBank.findFirstNonNull(level)]);
                        }
                        throw new IllegalArgumentException("circular reference detected: " + String.join((CharSequence)"->", reversedPath));
                    }
                    if (visitedFromThisStartNode.contains(node)) {
                        nodesVisitedMoreThanOnceInAPath.add(node);
                        endOfThisPath = true;
                    } else {
                        visitedFromThisStartNode.add(node);
                        String[] neighbors = PatternBank.getPatternNamesForPattern(bank, node);
                        if (neighbors.length == 0) {
                            endOfThisPath = true;
                        } else {
                            stack.push(neighbors);
                        }
                    }
                }
                if (endOfThisPath) {
                    if (firstNonNullIndex == currentLevel.length - 1) {
                        stack.pop();
                        unwinding = true;
                        continue;
                    }
                    currentLevel[firstNonNullIndex] = null;
                    unwinding = false;
                    continue;
                }
                unwinding = false;
            }
            allVisitedNodes.addAll(visitedFromThisStartNode);
        }
    }

    private static int findFirstNonNull(String[] level) {
        for (int i = 0; i < level.length; ++i) {
            if (level[i] == null) continue;
            return i;
        }
        return -1;
    }

    private static String[] getPatternNamesForPattern(Map<String, String> bank, String patternName) {
        String pattern = bank.get(patternName);
        ArrayList<String> patternReferences = new ArrayList<String>();
        int i = pattern.indexOf("%{");
        while (i != -1) {
            int end;
            int begin = i + 2;
            int bracketIndex = pattern.indexOf(125, begin);
            int columnIndex = pattern.indexOf(58, begin);
            if (bracketIndex != -1 && columnIndex == -1) {
                end = bracketIndex;
            } else if (columnIndex != -1 && bracketIndex == -1) {
                end = columnIndex;
            } else if (bracketIndex != -1) {
                end = Math.min(bracketIndex, columnIndex);
            } else {
                throw new IllegalArgumentException("pattern [" + pattern + "] has an invalid syntax");
            }
            String otherPatternName = pattern.substring(begin, end);
            if (!patternReferences.contains(otherPatternName)) {
                patternReferences.add(otherPatternName);
                String otherPattern = bank.get(otherPatternName);
                if (otherPattern == null) {
                    throw new IllegalArgumentException("pattern [" + patternName + "] is referencing a non-existent pattern [" + otherPatternName + "]");
                }
            }
            i = pattern.indexOf("%{", i + 1);
        }
        return patternReferences.toArray(new String[0]);
    }
}

