/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.apikey;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateApiKeyRequestTranslator;
import org.elasticsearch.xpack.security.rest.action.apikey.ApiKeyBaseRestHandler;

@ServerlessScope(value=Scope.PUBLIC)
public final class RestUpdateApiKeyAction
extends ApiKeyBaseRestHandler {
    private final UpdateApiKeyRequestTranslator requestTranslator;

    public RestUpdateApiKeyAction(Settings settings, XPackLicenseState licenseState, UpdateApiKeyRequestTranslator requestTranslator) {
        super(settings, licenseState);
        this.requestTranslator = requestTranslator;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_security/api_key/{ids}"));
    }

    public String getName() {
        return "xpack_security_update_api_key";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        UpdateApiKeyRequest updateApiKeyRequest = this.requestTranslator.translate(request);
        return channel -> client.execute((ActionType)UpdateApiKeyAction.INSTANCE, (ActionRequest)updateApiKeyRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

