/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.action.Grant;

public abstract class SecurityBaseRestHandler
extends BaseRestHandler {
    protected static final ConstructingObjectParser<Grant.ClientAuthentication, Void> CLIENT_AUTHENTICATION_PARSER = new ConstructingObjectParser("client_authentication", a -> new Grant.ClientAuthentication((String)a[0], (SecureString)a[1]));
    protected final Settings settings;
    protected final XPackLicenseState licenseState;

    protected static SecureString getSecureString(XContentParser parser) throws IOException {
        return new SecureString(Arrays.copyOfRange(parser.textCharacters(), parser.textOffset(), parser.textOffset() + parser.textLength()));
    }

    protected SecurityBaseRestHandler(Settings settings, XPackLicenseState licenseState) {
        this.settings = settings;
        this.licenseState = licenseState;
    }

    protected final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        Exception failedFeature = this.checkFeatureAvailable(request);
        if (failedFeature == null) {
            return this.innerPrepareRequest(request, client);
        }
        request.params().keySet().forEach(key -> request.param(key, ""));
        request.content();
        return channel -> channel.sendResponse(new RestResponse(channel, failedFeature));
    }

    public final Exception checkFeatureAvailable(RestRequest request) {
        if (!((Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings)).booleanValue()) {
            return new IllegalStateException("Security is not enabled but a security rest handler is registered");
        }
        return this.innerCheckFeatureAvailable(request);
    }

    protected Exception innerCheckFeatureAvailable(RestRequest request) {
        return null;
    }

    protected abstract BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest var1, NodeClient var2) throws IOException;

    static {
        CLIENT_AUTHENTICATION_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("scheme", new String[0]));
        CLIENT_AUTHENTICATION_PARSER.declareField(ConstructingObjectParser.constructorArg(), SecurityBaseRestHandler::getSecureString, new ParseField("value", new String[0]), ObjectParser.ValueType.STRING);
    }
}

