/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.jwt;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import org.elasticsearch.xpack.security.authc.jwt.JwtFieldValidator;

public class JwtTypeValidator
implements JwtFieldValidator {
    private static final JOSEObjectTypeVerifier<SecurityContext> JWT_HEADER_TYPE_VERIFIER = new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{JOSEObjectType.JWT, null});
    public static final JwtTypeValidator INSTANCE = new JwtTypeValidator();

    private JwtTypeValidator() {
    }

    @Override
    public void validate(JWSHeader jwsHeader, JWTClaimsSet jwtClaimsSet) {
        JOSEObjectType jwtHeaderType = jwsHeader.getType();
        try {
            JWT_HEADER_TYPE_VERIFIER.verify(jwtHeaderType, null);
        }
        catch (BadJOSEException e) {
            throw new IllegalArgumentException("invalid jwt typ header", e);
        }
    }
}

