/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import com.maxmind.db.NoCache;
import com.maxmind.db.NodeCache;
import com.maxmind.db.Reader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.ingest.geoip.GeoIpCache;
import org.elasticsearch.ingest.geoip.IpDatabase;
import org.elasticsearch.ingest.geoip.MMDBUtil;

public class DatabaseReaderLazyLoader
implements IpDatabase {
    private static final boolean LOAD_DATABASE_ON_HEAP = Booleans.parseBoolean((String)System.getProperty("es.geoip.load_db_on_heap", "false"));
    private static final Logger logger = LogManager.getLogger(DatabaseReaderLazyLoader.class);
    private final String md5;
    private final GeoIpCache cache;
    private final Path databasePath;
    private final CheckedSupplier<Reader, IOException> loader;
    final SetOnce<Reader> databaseReader;
    final SetOnce<String> databaseType;
    final SetOnce<Long> buildDate;
    private volatile boolean deleteDatabaseFileOnShutdown;
    private final AtomicInteger currentUsages = new AtomicInteger(0);
    private final String cachedDatabasePathToString;

    DatabaseReaderLazyLoader(GeoIpCache cache, Path databasePath, String md5) {
        this.cache = cache;
        this.databasePath = Objects.requireNonNull(databasePath);
        this.md5 = md5;
        this.loader = DatabaseReaderLazyLoader.createDatabaseLoader(databasePath);
        this.databaseReader = new SetOnce();
        this.databaseType = new SetOnce();
        this.buildDate = new SetOnce();
        this.cachedDatabasePathToString = databasePath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getDatabaseType() throws IOException {
        if (this.databaseType.get() == null) {
            SetOnce<String> setOnce = this.databaseType;
            synchronized (setOnce) {
                if (this.databaseType.get() == null) {
                    this.databaseType.set((Object)MMDBUtil.getDatabaseType(this.databasePath));
                }
            }
        }
        return (String)this.databaseType.get();
    }

    boolean preLookup() {
        return this.currentUsages.updateAndGet(current -> current < 0 ? current : current + 1) > 0;
    }

    @Override
    public void close() throws IOException {
        if (this.currentUsages.updateAndGet(current -> current > 0 ? current - 1 : current + 1) == -1) {
            this.doShutdown();
        }
    }

    int current() {
        return this.currentUsages.get();
    }

    @Override
    @Nullable
    public <RESPONSE> RESPONSE getResponse(String ipAddress, CheckedBiFunction<Reader, String, RESPONSE, Exception> responseProvider) {
        return (RESPONSE)this.cache.putIfAbsent(ipAddress, this.cachedDatabasePathToString, ip -> {
            try {
                return responseProvider.apply((Object)this.get(), (Object)ipAddress);
            }
            catch (Exception e) {
                throw ExceptionsHelper.convertToRuntime((Exception)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Reader get() throws IOException {
        if (this.databaseReader.get() == null) {
            SetOnce<Reader> setOnce = this.databaseReader;
            synchronized (setOnce) {
                if (this.databaseReader.get() == null) {
                    this.databaseReader.set((Object)((Reader)this.loader.get()));
                    logger.debug("loaded [{}] geo-IP database", (Object)this.databasePath);
                }
            }
        }
        return (Reader)this.databaseReader.get();
    }

    String getMd5() {
        return this.md5;
    }

    public void shutdown(boolean shouldDeleteDatabaseFileOnShutdown) throws IOException {
        this.deleteDatabaseFileOnShutdown = shouldDeleteDatabaseFileOnShutdown;
        this.shutdown();
    }

    public void shutdown() throws IOException {
        if (this.currentUsages.updateAndGet(u -> -1 - u) == -1) {
            this.doShutdown();
        }
    }

    protected void doShutdown() throws IOException {
        IOUtils.close((Closeable)((Closeable)this.databaseReader.get()));
        int numEntriesEvicted = this.cache.purgeCacheEntriesForDatabase(this.databasePath);
        logger.info("evicted [{}] entries from cache after reloading database [{}]", (Object)numEntriesEvicted, (Object)this.databasePath);
        if (this.deleteDatabaseFileOnShutdown) {
            logger.info("deleting [{}]", (Object)this.databasePath);
            Files.delete(this.databasePath);
        }
    }

    private static CheckedSupplier<Reader, IOException> createDatabaseLoader(Path databasePath) {
        return () -> {
            Reader.FileMode mode = LOAD_DATABASE_ON_HEAP ? Reader.FileMode.MEMORY : Reader.FileMode.MEMORY_MAPPED;
            return new Reader(DatabaseReaderLazyLoader.pathToFile(databasePath), mode, (NodeCache)NoCache.getInstance());
        };
    }

    @SuppressForbidden(reason="Maxmind API requires java.io.File")
    private static File pathToFile(Path databasePath) {
        return databasePath.toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getBuildDateMillis() throws IOException {
        if (this.buildDate.get() == null) {
            SetOnce<Long> setOnce = this.buildDate;
            synchronized (setOnce) {
                if (this.buildDate.get() == null) {
                    this.buildDate.set((Object)((Reader)this.loader.get()).getMetadata().getBuildDate().getTime());
                }
            }
        }
        return (Long)this.buildDate.get();
    }
}

