/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.planner;

import java.util.List;
import org.elasticsearch.xpack.eql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.eql.planner.Mapper;
import org.elasticsearch.xpack.eql.planner.PlanningException;
import org.elasticsearch.xpack.eql.planner.QueryFolder;
import org.elasticsearch.xpack.eql.planner.Verifier;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;

public class Planner {
    private final Mapper mapper = new Mapper();
    private final QueryFolder folder = new QueryFolder();

    public PhysicalPlan plan(LogicalPlan plan) {
        return this.foldPlan(this.mapPlan(plan));
    }

    PhysicalPlan mapPlan(LogicalPlan plan) {
        return this.verifyMappingPlan(this.mapper.map(plan));
    }

    PhysicalPlan foldPlan(PhysicalPlan mapped) {
        return this.verifyExecutingPlan(this.folder.fold(mapped));
    }

    PhysicalPlan verifyMappingPlan(PhysicalPlan plan) {
        List<Failure> failures = Verifier.verifyMappingPlan(plan);
        if (!failures.isEmpty()) {
            throw new PlanningException(failures);
        }
        return plan;
    }

    PhysicalPlan verifyExecutingPlan(PhysicalPlan plan) {
        List<Failure> failures = Verifier.verifyExecutingPlan(plan);
        if (!failures.isEmpty()) {
            throw new PlanningException(failures);
        }
        return plan;
    }
}

