/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.indices;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.admin.indices.recovery.RecoveryResponse;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;

public class IndexRecoveryMonitoringDoc
extends MonitoringDoc {
    public static final String TYPE = "index_recovery";
    private final RecoveryResponse recoveryResponse;

    public IndexRecoveryMonitoringDoc(String cluster, long timestamp, long intervalMillis, MonitoringDoc.Node node, RecoveryResponse recoveryResponse) {
        super(cluster, timestamp, intervalMillis, node, MonitoredSystem.ES, TYPE, null);
        this.recoveryResponse = Objects.requireNonNull(recoveryResponse);
    }

    RecoveryResponse getRecoveryResponse() {
        return this.recoveryResponse;
    }

    protected void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(TYPE);
        if (this.recoveryResponse != null) {
            builder.startArray("shards");
            Map shards = this.recoveryResponse.shardRecoveryStates();
            if (shards != null) {
                for (Map.Entry shard : shards.entrySet()) {
                    List indexShards = (List)shard.getValue();
                    if (indexShards == null) continue;
                    for (RecoveryState indexShard : indexShards) {
                        builder.startObject();
                        builder.field("index_name", (String)shard.getKey());
                        indexShard.toXContent(builder, params);
                        builder.endObject();
                    }
                }
            }
            builder.endArray();
        }
        builder.endObject();
    }
}

