/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.util;

import java.nio.ByteOrder;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BoundsChecking;
import org.apache.arrow.memory.util.MemoryUtil;
import org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.apache.arrow.memory.util.hash.SimpleHasher;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteFunctionHelpers {
    static final @UnknownKeyFor @NonNull @Initialized Logger logger = LoggerFactory.getLogger(ByteFunctionHelpers.class);
    private static final @UnknownKeyFor @NonNull @Initialized boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;

    private ByteFunctionHelpers() {
    }

    public static @UnknownKeyFor @NonNull @Initialized int equal(@UnknownKeyFor @NonNull @Initialized ArrowBuf left, @UnknownKeyFor @NonNull @Initialized long lStart, @UnknownKeyFor @NonNull @Initialized long lEnd, @UnknownKeyFor @NonNull @Initialized ArrowBuf right, @UnknownKeyFor @NonNull @Initialized long rStart, @UnknownKeyFor @NonNull @Initialized long rEnd) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            left.checkBytes(lStart, lEnd);
            right.checkBytes(rStart, rEnd);
        }
        return ByteFunctionHelpers.memEqual(left.memoryAddress(), lStart, lEnd, right.memoryAddress(), rStart, rEnd);
    }

    private static @UnknownKeyFor @NonNull @Initialized int memEqual(@UnknownKeyFor @NonNull @Initialized long laddr, @UnknownKeyFor @NonNull @Initialized long lStart, @UnknownKeyFor @NonNull @Initialized long lEnd, @UnknownKeyFor @NonNull @Initialized long raddr, @UnknownKeyFor @NonNull @Initialized long rStart, @UnknownKeyFor @NonNull @Initialized long rEnd) {
        long n = lEnd - lStart;
        if (n == rEnd - rStart) {
            long lPos = laddr + lStart;
            long rPos = raddr + rStart;
            while (n > 63L) {
                for (int x = 0; x < 8; ++x) {
                    long rightLong;
                    long leftLong = MemoryUtil.UNSAFE.getLong(lPos);
                    if (leftLong != (rightLong = MemoryUtil.UNSAFE.getLong(rPos))) {
                        return 0;
                    }
                    lPos += 8L;
                    rPos += 8L;
                }
                n -= 64L;
            }
            while (n > 7L) {
                long rightLong;
                long leftLong = MemoryUtil.UNSAFE.getLong(lPos);
                if (leftLong != (rightLong = MemoryUtil.UNSAFE.getLong(rPos))) {
                    return 0;
                }
                lPos += 8L;
                rPos += 8L;
                n -= 8L;
            }
            if (n > 3L) {
                int rightInt;
                int leftInt = MemoryUtil.UNSAFE.getInt(lPos);
                if (leftInt != (rightInt = MemoryUtil.UNSAFE.getInt(rPos))) {
                    return 0;
                }
                lPos += 4L;
                rPos += 4L;
                n -= 4L;
            }
            while (n-- != 0L) {
                byte rightByte;
                byte leftByte = MemoryUtil.UNSAFE.getByte(lPos);
                if (leftByte != (rightByte = MemoryUtil.UNSAFE.getByte(rPos))) {
                    return 0;
                }
                ++lPos;
                ++rPos;
            }
            return 1;
        }
        return 0;
    }

    public static @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized ArrowBuf left, @UnknownKeyFor @NonNull @Initialized long lStart, @UnknownKeyFor @NonNull @Initialized long lEnd, @UnknownKeyFor @NonNull @Initialized ArrowBuf right, @UnknownKeyFor @NonNull @Initialized long rStart, @UnknownKeyFor @NonNull @Initialized long rEnd) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            left.checkBytes(lStart, lEnd);
            right.checkBytes(rStart, rEnd);
        }
        return ByteFunctionHelpers.memcmp(left.memoryAddress(), lStart, lEnd, right.memoryAddress(), rStart, rEnd);
    }

    private static @UnknownKeyFor @NonNull @Initialized int memcmp(@UnknownKeyFor @NonNull @Initialized long laddr, @UnknownKeyFor @NonNull @Initialized long lStart, @UnknownKeyFor @NonNull @Initialized long lEnd, @UnknownKeyFor @NonNull @Initialized long raddr, @UnknownKeyFor @NonNull @Initialized long rStart, @UnknownKeyFor @NonNull @Initialized long rEnd) {
        long n;
        long lLen = lEnd - lStart;
        long rLen = rEnd - rStart;
        long lPos = laddr + lStart;
        long rPos = raddr + rStart;
        for (n = Math.min(rLen, lLen); n > 63L; n -= 64L) {
            for (int x = 0; x < 8; ++x) {
                long rightLong;
                long leftLong = MemoryUtil.UNSAFE.getLong(lPos);
                if (leftLong != (rightLong = MemoryUtil.UNSAFE.getLong(rPos))) {
                    if (LITTLE_ENDIAN) {
                        return ByteFunctionHelpers.unsignedLongCompare(Long.reverseBytes(leftLong), Long.reverseBytes(rightLong));
                    }
                    return ByteFunctionHelpers.unsignedLongCompare(leftLong, rightLong);
                }
                lPos += 8L;
                rPos += 8L;
            }
        }
        while (n > 7L) {
            long rightLong;
            long leftLong = MemoryUtil.UNSAFE.getLong(lPos);
            if (leftLong != (rightLong = MemoryUtil.UNSAFE.getLong(rPos))) {
                if (LITTLE_ENDIAN) {
                    return ByteFunctionHelpers.unsignedLongCompare(Long.reverseBytes(leftLong), Long.reverseBytes(rightLong));
                }
                return ByteFunctionHelpers.unsignedLongCompare(leftLong, rightLong);
            }
            lPos += 8L;
            rPos += 8L;
            n -= 8L;
        }
        if (n > 3L) {
            int rightInt;
            int leftInt = MemoryUtil.UNSAFE.getInt(lPos);
            if (leftInt != (rightInt = MemoryUtil.UNSAFE.getInt(rPos))) {
                if (LITTLE_ENDIAN) {
                    return ByteFunctionHelpers.unsignedIntCompare(Integer.reverseBytes(leftInt), Integer.reverseBytes(rightInt));
                }
                return ByteFunctionHelpers.unsignedIntCompare(leftInt, rightInt);
            }
            lPos += 4L;
            rPos += 4L;
            n -= 4L;
        }
        while (n-- != 0L) {
            byte rightByte;
            byte leftByte = MemoryUtil.UNSAFE.getByte(lPos);
            if (leftByte != (rightByte = MemoryUtil.UNSAFE.getByte(rPos))) {
                return (leftByte & 0xFF) - (rightByte & 0xFF) > 0 ? 1 : -1;
            }
            ++lPos;
            ++rPos;
        }
        if (lLen == rLen) {
            return 0;
        }
        return lLen > rLen ? 1 : -1;
    }

    public static @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized ArrowBuf left, @UnknownKeyFor @NonNull @Initialized int lStart, @UnknownKeyFor @NonNull @Initialized int lEnd, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] right, @UnknownKeyFor @NonNull @Initialized int rStart, @UnknownKeyFor @NonNull @Initialized int rEnd) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            left.checkBytes(lStart, lEnd);
        }
        return ByteFunctionHelpers.memcmp(left.memoryAddress(), lStart, lEnd, right, rStart, rEnd);
    }

    public static @UnknownKeyFor @NonNull @Initialized int unsignedLongCompare(@UnknownKeyFor @NonNull @Initialized long a, @UnknownKeyFor @NonNull @Initialized long b) {
        return Long.compare(a ^ Long.MIN_VALUE, b ^ Long.MIN_VALUE);
    }

    public static @UnknownKeyFor @NonNull @Initialized int unsignedIntCompare(@UnknownKeyFor @NonNull @Initialized int a, @UnknownKeyFor @NonNull @Initialized int b) {
        return Integer.compare(a ^ Integer.MIN_VALUE, b ^ Integer.MIN_VALUE);
    }

    private static @UnknownKeyFor @NonNull @Initialized int memcmp(@UnknownKeyFor @NonNull @Initialized long laddr, @UnknownKeyFor @NonNull @Initialized int lStart, @UnknownKeyFor @NonNull @Initialized int lEnd, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] right, @UnknownKeyFor @NonNull @Initialized int rStart, @UnknownKeyFor @NonNull @Initialized int rEnd) {
        int n;
        int lLen = lEnd - lStart;
        int rLen = rEnd - rStart;
        long lPos = laddr + (long)lStart;
        int rPos = rStart;
        for (n = Math.min(rLen, lLen); n > 7; n -= 8) {
            long rightLong;
            long leftLong = MemoryUtil.UNSAFE.getLong(lPos);
            if (leftLong != (rightLong = MemoryUtil.UNSAFE.getLong(right, MemoryUtil.BYTE_ARRAY_BASE_OFFSET + (long)rPos))) {
                if (LITTLE_ENDIAN) {
                    return ByteFunctionHelpers.unsignedLongCompare(Long.reverseBytes(leftLong), Long.reverseBytes(rightLong));
                }
                return ByteFunctionHelpers.unsignedLongCompare(leftLong, rightLong);
            }
            lPos += 8L;
            rPos += 8;
        }
        if (n > 3) {
            int rightInt;
            int leftInt = MemoryUtil.UNSAFE.getInt(lPos);
            if (leftInt != (rightInt = MemoryUtil.UNSAFE.getInt(right, MemoryUtil.BYTE_ARRAY_BASE_OFFSET + (long)rPos))) {
                if (LITTLE_ENDIAN) {
                    return ByteFunctionHelpers.unsignedIntCompare(Integer.reverseBytes(leftInt), Integer.reverseBytes(rightInt));
                }
                return ByteFunctionHelpers.unsignedIntCompare(leftInt, rightInt);
            }
            lPos += 4L;
            rPos += 4;
            n -= 4;
        }
        while (n-- != 0) {
            byte rightByte;
            byte leftByte = MemoryUtil.UNSAFE.getByte(lPos);
            if (leftByte != (rightByte = right[rPos])) {
                return (leftByte & 0xFF) - (rightByte & 0xFF) > 0 ? 1 : -1;
            }
            ++lPos;
            ++rPos;
        }
        if (lLen == rLen) {
            return 0;
        }
        return lLen > rLen ? 1 : -1;
    }

    public static @UnknownKeyFor @NonNull @Initialized int hash(@UnknownKeyFor @NonNull @Initialized ArrowBuf buf, @UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) {
        return ByteFunctionHelpers.hash(SimpleHasher.INSTANCE, buf, start, end);
    }

    public static final @UnknownKeyFor @NonNull @Initialized int hash(@UnknownKeyFor @NonNull @Initialized ArrowBufHasher hasher, @UnknownKeyFor @NonNull @Initialized ArrowBuf buf, @UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) {
        if (hasher == null) {
            hasher = SimpleHasher.INSTANCE;
        }
        return hasher.hashCode(buf, start, end - start);
    }

    public static @UnknownKeyFor @NonNull @Initialized int combineHash(@UnknownKeyFor @NonNull @Initialized int currentHash, @UnknownKeyFor @NonNull @Initialized int newHash) {
        return currentHash * 31 + newHash;
    }
}

