/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.datafeeds;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.PreviewDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPreviewDatafeedAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_ml/datafeeds/{" + String.valueOf(DatafeedConfig.ID) + "}/_preview"), new RestHandler.Route(RestRequest.Method.GET, "/_ml/datafeeds/_preview"), new RestHandler.Route(RestRequest.Method.POST, "/_ml/datafeeds/{" + String.valueOf(DatafeedConfig.ID) + "}/_preview"), new RestHandler.Route(RestRequest.Method.POST, "/_ml/datafeeds/_preview"));
    }

    public String getName() {
        return "ml_preview_datafeed_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String startTime = restRequest.param(StartDatafeedAction.START_TIME.getPreferredName(), null);
        String endTime = restRequest.param(StartDatafeedAction.END_TIME.getPreferredName(), null);
        PreviewDatafeedAction.Request request = restRequest.hasContentOrSourceParam() ? PreviewDatafeedAction.Request.fromXContent((XContentParser)restRequest.contentOrSourceParamParser(), (String)restRequest.param(DatafeedConfig.ID.getPreferredName(), null)).setStart(startTime).setEnd(endTime).build() : new PreviewDatafeedAction.Request(restRequest.param(DatafeedConfig.ID.getPreferredName()), startTime, endTime);
        return channel -> new RestCancellableNodeClient(client, restRequest.getHttpChannel()).execute((ActionType)PreviewDatafeedAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

