/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;

public class TransformFeatureSetUsage
extends XPackFeatureUsage {
    private static final String FEATURE_COUNTS = "feature_counts";
    private final Map<String, Long> transformCountByState;
    private final Map<String, Long> transformCountByFeature;
    private final TransformIndexerStats accumulatedStats;

    public TransformFeatureSetUsage(StreamInput in) throws IOException {
        super(in);
        this.transformCountByState = in.readMap(StreamInput::readLong);
        this.transformCountByFeature = in.readMap(StreamInput::readLong);
        this.accumulatedStats = new TransformIndexerStats(in);
    }

    public TransformFeatureSetUsage(Map<String, Long> transformCountByState, Map<String, Long> transformCountByFeature, TransformIndexerStats accumulatedStats) {
        super("transform", true, true);
        this.transformCountByState = Objects.requireNonNull(transformCountByState);
        this.transformCountByFeature = Objects.requireNonNull(transformCountByFeature);
        this.accumulatedStats = Objects.requireNonNull(accumulatedStats);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ZERO;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.transformCountByState, StreamOutput::writeLong);
        out.writeMap(this.transformCountByFeature, StreamOutput::writeLong);
        this.accumulatedStats.writeTo(out);
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        if (!this.transformCountByState.isEmpty()) {
            builder.startObject(TransformField.TRANSFORMS.getPreferredName());
            long all = 0L;
            for (Map.Entry<String, Long> entry : this.transformCountByState.entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
                all += entry.getValue().longValue();
            }
            builder.field("_all", all);
            builder.endObject();
            builder.field(FEATURE_COUNTS, this.transformCountByFeature);
            builder.field(TransformField.STATS_FIELD.getPreferredName(), (ToXContent)this.accumulatedStats);
        }
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.available, this.transformCountByState, this.transformCountByFeature, this.accumulatedStats);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransformFeatureSetUsage other = (TransformFeatureSetUsage)obj;
        return Objects.equals(this.name, other.name) && this.available == other.available && this.enabled == other.enabled && Objects.equals(this.transformCountByState, other.transformCountByState) && Objects.equals(this.transformCountByFeature, other.transformCountByFeature) && Objects.equals(this.accumulatedStats, other.accumulatedStats);
    }
}

