/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.azureaistudio;

import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.azureaistudio.AzureAiStudioEmbeddingsRequestEntity;
import org.elasticsearch.xpack.inference.external.request.azureaistudio.AzureAiStudioRequest;
import org.elasticsearch.xpack.inference.services.azureaistudio.embeddings.AzureAiStudioEmbeddingsModel;

public class AzureAiStudioEmbeddingsRequest
extends AzureAiStudioRequest {
    private final AzureAiStudioEmbeddingsModel embeddingsModel;
    private final Truncator.TruncationResult truncationResult;
    private final Truncator truncator;

    public AzureAiStudioEmbeddingsRequest(Truncator truncator, Truncator.TruncationResult input, AzureAiStudioEmbeddingsModel model) {
        super(model);
        this.embeddingsModel = model;
        this.truncator = truncator;
        this.truncationResult = input;
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.uri);
        String user = this.embeddingsModel.getTaskSettings().user();
        Integer dimensions = this.embeddingsModel.getServiceSettings().dimensions();
        Boolean dimensionsSetByUser = this.embeddingsModel.getServiceSettings().dimensionsSetByUser();
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new AzureAiStudioEmbeddingsRequestEntity(this.truncationResult.input(), user, dimensions, dimensionsSetByUser)).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaType());
        this.setAuthHeader((HttpEntityEnclosingRequestBase)httpPost, this.embeddingsModel);
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public Request truncate() {
        Truncator.TruncationResult truncatedInput = this.truncator.truncate(this.truncationResult.input());
        return new AzureAiStudioEmbeddingsRequest(this.truncator, truncatedInput, this.embeddingsModel);
    }

    @Override
    public boolean[] getTruncationInfo() {
        return (boolean[])this.truncationResult.truncated().clone();
    }
}

