/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.mapper.RangeType;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.LongBounds;
import org.elasticsearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

class DateRangeHistogramAggregator
extends BucketsAggregator {
    private final ValuesSource.Range valuesSource;
    private final DocValueFormat formatter;
    private final Rounding rounding;
    private final Rounding.Prepared preparedRounding;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final boolean downsampledResultsOffset;
    private final LongBounds extendedBounds;
    private final LongBounds hardBounds;
    private final LongKeyedBucketOrds bucketOrds;

    DateRangeHistogramAggregator(String name, AggregatorFactories factories, Rounding rounding, BucketOrder order, boolean keyed, long minDocCount, boolean downsampledResultsOffset, @Nullable LongBounds extendedBounds, @Nullable LongBounds hardBounds, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, CardinalityUpperBound.MANY, metadata);
        this.rounding = rounding;
        this.preparedRounding = valuesSourceConfig.roundingPreparer(context).apply(rounding);
        this.order = order;
        order.validate(this);
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.downsampledResultsOffset = downsampledResultsOffset;
        this.extendedBounds = extendedBounds;
        this.hardBounds = hardBounds;
        this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Range)valuesSourceConfig.getValuesSource() : null;
        this.formatter = valuesSourceConfig.format();
        if (this.valuesSource.rangeType() != RangeType.DATE) {
            throw new IllegalArgumentException("Expected date range type but found range type [" + this.valuesSource.rangeType().name + "]");
        }
        this.bucketOrds = LongKeyedBucketOrds.build(this.bigArrays(), cardinality);
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BinaryDocValues values = FieldData.unwrapSingleton(this.valuesSource.bytesValues(aggCtx.getLeafReaderContext()));
        assert (values != null);
        final RangeType rangeType = this.valuesSource.rangeType();
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    long previousKey = Long.MIN_VALUE;
                    List<RangeFieldMapper.Range> ranges = rangeType.decodeRanges(values.binaryValue());
                    long previousFrom = Long.MIN_VALUE;
                    for (RangeFieldMapper.Range range : ranges) {
                        Long from = (Long)range.getFrom();
                        assert (from >= previousFrom) : "Start of range not >= previous start";
                        Long to = (Long)range.getTo();
                        long effectiveFrom = DateRangeHistogramAggregator.this.hardBounds != null && DateRangeHistogramAggregator.this.hardBounds.getMin() != null ? Long.max(from, DateRangeHistogramAggregator.this.hardBounds.getMin()) : from;
                        long effectiveTo = DateRangeHistogramAggregator.this.hardBounds != null && DateRangeHistogramAggregator.this.hardBounds.getMax() != null ? Long.min(to, DateRangeHistogramAggregator.this.hardBounds.getMax()) : to;
                        long startKey = DateRangeHistogramAggregator.this.preparedRounding.round(effectiveFrom);
                        long endKey = DateRangeHistogramAggregator.this.preparedRounding.round(effectiveTo);
                        long key = Long.max(startKey, previousKey);
                        while (key <= endKey) {
                            if (key != previousKey) {
                                long bucketOrd = DateRangeHistogramAggregator.this.bucketOrds.add(owningBucketOrd, key);
                                if (bucketOrd < 0L) {
                                    bucketOrd = -1L - bucketOrd;
                                    DateRangeHistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                                } else {
                                    DateRangeHistogramAggregator.this.collectBucket(sub, doc, bucketOrd);
                                }
                            }
                            key = DateRangeHistogramAggregator.this.preparedRounding.nextRoundingValue(key);
                        }
                        if (endKey <= previousKey) continue;
                        previousKey = endKey;
                    }
                }
            }
        };
    }

    @Override
    public InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
        return this.buildAggregationsForVariableBuckets(owningBucketOrds, this.bucketOrds, (bucketValue, docCount, subAggregationResults) -> new InternalDateHistogram.Bucket(bucketValue, docCount, this.formatter, subAggregationResults), (owningBucketOrd, buckets) -> {
            CollectionUtil.introSort((List)buckets, BucketOrder.key(true).comparator());
            InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding.withoutOffset(), this.buildEmptySubAggregations(), this.extendedBounds) : null;
            return new InternalDateHistogram(this.name, buckets, this.order, this.minDocCount, this.rounding.offset(), emptyBucketInfo, this.formatter, this.keyed, this.downsampledResultsOffset, this.metadata());
        });
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations(), this.extendedBounds) : null;
        return new InternalDateHistogram(this.name, Collections.emptyList(), this.order, this.minDocCount, this.rounding.offset(), emptyBucketInfo, this.formatter, this.keyed, this.downsampledResultsOffset, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        add.accept("total_buckets", this.bucketOrds.size());
    }
}

