/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.script.Metadata;

final class IngestDocMetadata
extends Metadata {
    static final Map<String, Metadata.FieldProperty<?>> PROPERTIES = Map.of("_index", StringField.withWritable().withNullable(), "_id", StringField.withWritable().withNullable(), "_routing", StringField.withWritable().withNullable(), "_version_type", StringField.withWritable().withNullable().withValidation(IngestDocMetadata::versionTypeValidator), "_version", LongField.withWritable(), "_type", StringField.withNullable(), "_if_seq_no", LongField.withWritable().withNullable(), "_if_primary_term", LongField.withWritable().withNullable(), "_dynamic_templates", new Metadata.FieldProperty<Map>(Map.class).withWritable().withNullable());
    private static final char UNDERSCORE = '_';
    protected final ZonedDateTime timestamp;

    IngestDocMetadata(String index, String id, long version, String routing, VersionType versionType, ZonedDateTime timestamp) {
        this(IngestDocMetadata.metadataMap(index, id, version, routing, versionType), timestamp);
    }

    IngestDocMetadata(Map<String, Object> metadata, ZonedDateTime timestamp) {
        super(metadata, PROPERTIES);
        this.timestamp = timestamp;
    }

    protected static Map<String, Object> metadataMap(String index, String id, long version, String routing, VersionType versionType) {
        Map<String, Object> metadata = Maps.newHashMapWithExpectedSize(IngestDocument.Metadata.values().length);
        metadata.put(IngestDocument.Metadata.INDEX.getFieldName(), index);
        metadata.put(IngestDocument.Metadata.ID.getFieldName(), id);
        metadata.put(IngestDocument.Metadata.VERSION.getFieldName(), version);
        if (routing != null) {
            metadata.put(IngestDocument.Metadata.ROUTING.getFieldName(), routing);
        }
        if (versionType != null) {
            metadata.put(IngestDocument.Metadata.VERSION_TYPE.getFieldName(), VersionType.toString(versionType));
        }
        return metadata;
    }

    @Override
    public ZonedDateTime getNow() {
        return this.timestamp;
    }

    @Override
    public IngestDocMetadata clone() {
        return new IngestDocMetadata(new HashMap<String, Object>(this.map), this.timestamp);
    }

    private static void versionTypeValidator(String key, String value) {
        try {
            VersionType.fromString(value);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(key + " must be a null or one of [" + Arrays.stream(VersionType.values()).map(vt -> VersionType.toString(vt)).collect(Collectors.joining(", ")) + "] but was [" + value + "] with type [" + value.getClass().getName() + "]");
        }
    }

    @Override
    public boolean isAvailable(String key) {
        assert (key != null && !key.isEmpty());
        if (key.charAt(0) != '_') {
            return false;
        }
        return super.isAvailable(key);
    }

    static {
        for (String key : PROPERTIES.keySet()) {
            if (key.charAt(0) == '_') continue;
            throw new IllegalArgumentException("IngestDocMetadata keys must begin with an underscore, but found [" + key + "]");
        }
    }
}

