/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.util.EnumSet;
import java.util.Locale;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;

public enum SimilarityMeasure {
    COSINE,
    DOT_PRODUCT,
    L2_NORM;

    private static final EnumSet<SimilarityMeasure> BEFORE_L2_NORM_ENUMS;

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static SimilarityMeasure fromString(String name) {
        return SimilarityMeasure.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static SimilarityMeasure translateSimilarity(SimilarityMeasure similarityMeasure, TransportVersion version) {
        if (version.before(TransportVersions.V_8_14_0) && !BEFORE_L2_NORM_ENUMS.contains((Object)similarityMeasure)) {
            return null;
        }
        return similarityMeasure;
    }

    static {
        BEFORE_L2_NORM_ENUMS = EnumSet.range(COSINE, DOT_PRODUCT);
    }
}

