/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class SparseVectorStats
implements Writeable,
ToXContentFragment {
    private long valueCount = 0L;

    public SparseVectorStats() {
    }

    public SparseVectorStats(long count) {
        this.valueCount = count;
    }

    public SparseVectorStats(StreamInput in) throws IOException {
        this.valueCount = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.valueCount);
    }

    public void add(SparseVectorStats other) {
        if (other == null) {
            return;
        }
        this.valueCount += other.valueCount;
    }

    public long getValueCount() {
        return this.valueCount;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("sparse_vector");
        builder.field("value_count", this.valueCount);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparseVectorStats that = (SparseVectorStats)o;
        return this.valueCount == that.valueCount;
    }

    public int hashCode() {
        return Objects.hash(this.valueCount);
    }

    static final class Fields {
        static final String NAME = "sparse_vector";
        static final String VALUE_COUNT = "value_count";

        Fields() {
        }
    }
}

