/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.BinaryScriptFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IpScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.IpFieldScript;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class IpScriptFieldData
extends BinaryScriptFieldData {
    private final IpFieldScript.LeafFactory leafFactory;
    private final ToScriptFieldFactory<SortedBinaryDocValues> toScriptFieldFactory;

    private IpScriptFieldData(String fieldName, IpFieldScript.LeafFactory leafFactory, ToScriptFieldFactory<SortedBinaryDocValues> toScriptFieldFactory) {
        super(fieldName);
        this.leafFactory = leafFactory;
        this.toScriptFieldFactory = toScriptFieldFactory;
    }

    @Override
    public BinaryScriptFieldData.BinaryScriptLeafFieldData loadDirect(LeafReaderContext context) throws Exception {
        final IpFieldScript script = this.leafFactory.newInstance(context);
        return new BinaryScriptFieldData.BinaryScriptLeafFieldData(){

            @Override
            public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
                return IpScriptFieldData.this.toScriptFieldFactory.getScriptFieldFactory(this.getBytesValues(), name);
            }

            @Override
            public SortedBinaryDocValues getBytesValues() {
                return new IpScriptDocValues(script);
            }
        };
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return CoreValuesSourceType.IP;
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final IpFieldScript.LeafFactory leafFactory;
        private final ToScriptFieldFactory<SortedBinaryDocValues> toScriptFieldFactory;

        public Builder(String name, IpFieldScript.LeafFactory leafFactory, ToScriptFieldFactory<SortedBinaryDocValues> toScriptFieldFactory) {
            this.name = name;
            this.leafFactory = leafFactory;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        public IpScriptFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new IpScriptFieldData(this.name, this.leafFactory, this.toScriptFieldFactory);
        }
    }
}

