/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndexComponentSelector;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.transport.RemoteClusterAware;

public class IndexNameExpressionResolver {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(IndexNameExpressionResolver.class);
    public static final String EXCLUDED_DATA_STREAMS_KEY = "es.excluded_ds";
    public static final IndexVersion SYSTEM_INDEX_ENFORCEMENT_INDEX_VERSION = IndexVersions.V_8_0_0;
    private final ThreadContext threadContext;
    private final SystemIndices systemIndices;

    public IndexNameExpressionResolver(ThreadContext threadContext, SystemIndices systemIndices) {
        this.threadContext = Objects.requireNonNull(threadContext, "Thread Context must not be null");
        this.systemIndices = Objects.requireNonNull(systemIndices, "System Indices must not be null");
    }

    public String[] concreteIndexNames(ClusterState state, IndicesRequest request) {
        Context context = new Context(state, request.indicesOptions(), false, false, request.includeDataStreams(), this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        return this.concreteIndexNames(context, request.indices());
    }

    public String[] concreteIndexNamesWithSystemIndexAccess(ClusterState state, IndicesRequest request) {
        Context context = new Context(state, request.indicesOptions(), false, false, request.includeDataStreams(), SystemIndices.SystemIndexAccessLevel.BACKWARDS_COMPATIBLE_ONLY, Predicates.always(), this.getNetNewSystemIndexPredicate());
        return this.concreteIndexNames(context, request.indices());
    }

    public Index[] concreteIndices(ClusterState state, IndicesRequest request) {
        Context context = new Context(state, request.indicesOptions(), false, false, request.includeDataStreams(), this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        return this.concreteIndices(context, request.indices());
    }

    public String[] concreteIndexNames(ClusterState state, IndicesOptions options, String ... indexExpressions) {
        Context context = new Context(state, options, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        return this.concreteIndexNames(context, indexExpressions);
    }

    public String[] concreteIndexNames(ClusterState state, IndicesOptions options, boolean includeDataStreams, String ... indexExpressions) {
        Context context = new Context(state, options, false, false, includeDataStreams, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        return this.concreteIndexNames(context, indexExpressions);
    }

    public String[] concreteIndexNames(ClusterState state, IndicesOptions options, IndicesRequest request) {
        Context context = new Context(state, options, false, false, request.includeDataStreams(), this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        return this.concreteIndexNames(context, request.indices());
    }

    public List<String> dataStreamNames(ClusterState state, IndicesOptions options, String ... indexExpressions) {
        return this.dataStreams(state, options, indexExpressions).stream().map(ResolvedExpression::resource).distinct().toList();
    }

    public List<ResolvedExpression> dataStreams(ClusterState state, IndicesOptions options, String ... indexExpressions) {
        Context context = new Context(state, options, false, false, true, true, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        Collection<ResolvedExpression> expressions = IndexNameExpressionResolver.resolveExpressionsToResources(context, indexExpressions);
        return expressions.stream().filter(expression -> {
            IndexAbstraction ia = (IndexAbstraction)state.metadata().getIndicesLookup().get(expression.resource());
            return ia != null && IndexAbstraction.Type.DATA_STREAM == ia.getType();
        }).toList();
    }

    public IndexAbstraction resolveWriteIndexAbstraction(ClusterState state, DocWriteRequest<?> request) {
        boolean includeDataStreams = request.opType() == DocWriteRequest.OpType.CREATE && request.includeDataStreams();
        Context context = new Context(state, request.indicesOptions(), false, false, includeDataStreams, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        Collection<ResolvedExpression> expressions = IndexNameExpressionResolver.resolveExpressionsToResources(context, request.index());
        if (expressions.size() == 1) {
            Index writeIndex;
            ResolvedExpression resolvedExpression = expressions.iterator().next();
            IndexAbstraction ia = (IndexAbstraction)state.metadata().getIndicesLookup().get(resolvedExpression.resource());
            if (ia.getType() == IndexAbstraction.Type.ALIAS && (writeIndex = ia.getWriteIndex()) == null) {
                throw new IllegalArgumentException("no write index is defined for alias [" + ia.getName() + "]. The write index may be explicitly disabled using is_write_index=false or the alias points to multiple indices without one being designated as a write index");
            }
            SystemResourceAccess.checkSystemIndexAccess(context, this.threadContext, ia.getWriteIndex());
            return ia;
        }
        throw new IllegalArgumentException("unable to return a single target as the provided expression and options got resolved to multiple targets");
    }

    protected static Collection<ResolvedExpression> resolveExpressionsToResources(Context context, String ... expressions) {
        boolean expandWildcards = context.getOptions().expandWildcardExpressions();
        if (!expandWildcards) {
            if (expressions == null || expressions.length == 0 || expressions.length == 1 && SelectorResolver.selectorsValidatedAndMatchesPredicate(expressions[0], context, "_all"::equals)) {
                return List.of();
            }
        } else {
            Predicate<String> isMatchAll = ((Predicate<String>)"_all"::equals).or(Regex::isMatchAllPattern);
            if (expressions == null || expressions.length == 0 || expressions.length == 1 && SelectorResolver.selectorsValidatedAndMatchesPredicate(expressions[0], context, isMatchAll)) {
                IndexComponentSelector selector = expressions != null && expressions.length == 1 ? SelectorResolver.parseMatchAllToSelector(context, expressions[0]) : IndexComponentSelector.DATA;
                return WildcardExpressionResolver.resolveAll(context, selector);
            }
            if (IndexNameExpressionResolver.isNoneExpression(expressions)) {
                return List.of();
            }
        }
        ArrayList<ResolvedExpression> resources = expandWildcards && WildcardExpressionResolver.hasWildcards(expressions) ? new LinkedHashSet() : new ArrayList(expressions.length);
        boolean wildcardSeen = false;
        int n = expressions.length;
        for (int i = 0; i < n; ++i) {
            String originalExpression = expressions[i];
            boolean isExclusion = wildcardSeen && originalExpression.startsWith("-");
            String baseExpression = isExclusion ? originalExpression.substring(1) : originalExpression;
            ResolvedExpression partiallyResolvedExpression = SelectorResolver.parseExpression(baseExpression, context.getOptions());
            baseExpression = partiallyResolvedExpression.resource();
            IndexComponentSelector selector = partiallyResolvedExpression.selector();
            baseExpression = DateMathExpressionResolver.resolveExpression(baseExpression, context::getStartTime);
            IndexNameExpressionResolver.validateResourceExpression(context, baseExpression, expressions);
            boolean isWildcard = expandWildcards && WildcardExpressionResolver.isWildcard(baseExpression);
            wildcardSeen |= isWildcard;
            if (isWildcard) {
                Set<ResolvedExpression> matchingResources = WildcardExpressionResolver.matchWildcardToResources(context, baseExpression, selector);
                if (!context.getOptions().allowNoIndices() && matchingResources.isEmpty()) {
                    throw IndexNameExpressionResolver.notFoundException(IndexNameExpressionResolver.combineSelector(baseExpression, partiallyResolvedExpression.selector()));
                }
                if (isExclusion) {
                    resources.removeAll(matchingResources);
                    continue;
                }
                resources.addAll(matchingResources);
                continue;
            }
            if (isExclusion) {
                resources.remove(new ResolvedExpression(baseExpression, selector));
                continue;
            }
            if (!IndexNameExpressionResolver.ensureAliasOrIndexExists(context, baseExpression, selector)) continue;
            resources.add(new ResolvedExpression(baseExpression, selector));
        }
        return resources;
    }

    private static void validateResourceExpression(Context context, String current, String[] expressions) {
        if (Strings.isEmpty(current)) {
            throw IndexNameExpressionResolver.notFoundException(current);
        }
        if (current.charAt(0) == '_') {
            throw new InvalidIndexNameException(current, "must not start with '_'.");
        }
        IndexNameExpressionResolver.ensureRemoteExpressionRequireIgnoreUnavailable(context.getOptions(), current, expressions);
    }

    private static void ensureRemoteExpressionRequireIgnoreUnavailable(IndicesOptions options, String current, String[] expressions) {
        if (options.ignoreUnavailable()) {
            return;
        }
        if (RemoteClusterAware.isRemoteIndexName(current)) {
            ArrayList<String> crossClusterIndices = new ArrayList<String>();
            for (int i = 0; i < expressions.length; ++i) {
                if (!RemoteClusterAware.isRemoteIndexName(expressions[i])) continue;
                crossClusterIndices.add(expressions[i]);
            }
            throw new IllegalArgumentException("Cross-cluster calls are not supported in this context but remote indices were requested: " + String.valueOf(crossClusterIndices));
        }
    }

    public Index[] concreteIndices(ClusterState state, IndicesOptions options, String ... indexExpressions) {
        return this.concreteIndices(state, options, false, indexExpressions);
    }

    public Index[] concreteIndices(ClusterState state, IndicesOptions options, boolean includeDataStreams, String ... indexExpressions) {
        Context context = new Context(state, options, false, false, includeDataStreams, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        return this.concreteIndices(context, indexExpressions);
    }

    public Index[] concreteIndices(ClusterState state, IndicesRequest request, long startTime) {
        Context context = new Context(state, request.indicesOptions(), startTime, false, false, request.includeDataStreams(), false, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        return this.concreteIndices(context, request.indices());
    }

    String[] concreteIndexNames(Context context, String ... indexExpressions) {
        Index[] indexes = this.concreteIndices(context, indexExpressions);
        String[] names = new String[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            names[i] = indexes[i].getName();
        }
        return names;
    }

    Index[] concreteIndices(Context context, String ... indexExpressions) {
        Collection<ResolvedExpression> expressions = IndexNameExpressionResolver.resolveExpressionsToResources(context, indexExpressions);
        LinkedHashSet<Index> concreteIndicesResult = Sets.newLinkedHashSetWithExpectedSize(expressions.size());
        SortedMap<String, IndexAbstraction> indicesLookup = context.getState().metadata().getIndicesLookup();
        for (ResolvedExpression expression : expressions) {
            int i;
            IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(expression.resource());
            assert (indexAbstraction != null);
            if (context.isResolveToWriteIndex()) {
                Index failureStoreWriteIndex;
                if (IndexNameExpressionResolver.shouldIncludeRegularIndices(context.getOptions(), expression.selector())) {
                    Index writeIndex = indexAbstraction.getWriteIndex();
                    if (writeIndex == null && indexAbstraction.getType() == IndexAbstraction.Type.ALIAS) {
                        throw new IllegalArgumentException("no write index is defined for alias [" + indexAbstraction.getName() + "]. The write index may be explicitly disabled using is_write_index=false or the alias points to multiple indices without one being designated as a write index");
                    }
                    if (IndexNameExpressionResolver.addIndex(writeIndex, null, context)) {
                        concreteIndicesResult.add(writeIndex);
                    }
                }
                if (!IndexNameExpressionResolver.shouldIncludeFailureIndices(context.getOptions(), expression.selector()) || (failureStoreWriteIndex = indexAbstraction.getWriteFailureIndex(context.state.metadata())) == null || !IndexNameExpressionResolver.addIndex(failureStoreWriteIndex, null, context)) continue;
                concreteIndicesResult.add(failureStoreWriteIndex);
                continue;
            }
            if (!context.getOptions().allowAliasesToMultipleIndices() && IndexNameExpressionResolver.resolvesToMoreThanOneIndex(indexAbstraction, context, expression)) {
                Object[] indexNames = new String[indexAbstraction.getIndices().size()];
                i = 0;
                for (Index indexName : indexAbstraction.getIndices()) {
                    indexNames[i++] = indexName.getName();
                }
                throw new IllegalArgumentException(indexAbstraction.getType().getDisplayName() + " [" + expression.resource() + "] has more than one index associated with it " + Arrays.toString(indexNames) + ", can't execute a single index op");
            }
            if (indexAbstraction.isDataStreamRelated()) {
                IndexNameExpressionResolver.resolveIndicesForDataStreamRelatedAbstraction(context, indexAbstraction, concreteIndicesResult, expression.selector());
                continue;
            }
            List<Index> indices = indexAbstraction.getIndices();
            int n = indices.size();
            for (i = 0; i < n; ++i) {
                Index index = indices.get(i);
                if (!IndexNameExpressionResolver.shouldTrackConcreteIndex(context, index)) continue;
                concreteIndicesResult.add(index);
            }
        }
        if (!context.getOptions().allowNoIndices() && concreteIndicesResult.isEmpty()) {
            throw IndexNameExpressionResolver.notFoundException(indexExpressions);
        }
        Index[] resultArray = concreteIndicesResult.toArray(Index.EMPTY_ARRAY);
        SystemResourceAccess.checkSystemIndexAccess(context, this.threadContext, resultArray);
        return resultArray;
    }

    private static void resolveIndicesForDataStreamRelatedAbstraction(Context context, IndexAbstraction indexAbstraction, Set<Index> concreteIndicesResult, IndexComponentSelector selector) {
        Index index;
        int i;
        int n;
        if (IndexNameExpressionResolver.shouldIncludeRegularIndices(context.getOptions(), selector)) {
            List<Index> indices = indexAbstraction.getIndices();
            n = indices.size();
            for (i = 0; i < n; ++i) {
                index = indices.get(i);
                if (!IndexNameExpressionResolver.shouldTrackConcreteIndex(context, index)) continue;
                concreteIndicesResult.add(index);
            }
        }
        if (IndexNameExpressionResolver.shouldIncludeFailureIndices(context.getOptions(), selector)) {
            List<Index> failureIndices = indexAbstraction.getFailureIndices(context.state.metadata());
            n = failureIndices.size();
            for (i = 0; i < n; ++i) {
                index = failureIndices.get(i);
                if (!IndexNameExpressionResolver.shouldTrackConcreteIndex(context, index)) continue;
                concreteIndicesResult.add(index);
            }
        }
    }

    private static void resolveWriteIndexForDataStreams(Context context, DataStream dataStream, Set<Index> concreteIndicesResult, IndexComponentSelector selector) {
        Index failureStoreWriteIndex;
        Index writeIndex;
        if (IndexNameExpressionResolver.shouldIncludeRegularIndices(context.getOptions(), selector) && IndexNameExpressionResolver.addIndex(writeIndex = dataStream.getWriteIndex(), null, context)) {
            concreteIndicesResult.add(writeIndex);
        }
        if (IndexNameExpressionResolver.shouldIncludeFailureIndices(context.getOptions(), selector) && (failureStoreWriteIndex = dataStream.getWriteFailureIndex()) != null && IndexNameExpressionResolver.addIndex(failureStoreWriteIndex, null, context)) {
            concreteIndicesResult.add(failureStoreWriteIndex);
        }
    }

    public static boolean shouldIncludeRegularIndices(IndicesOptions indicesOptions, IndexComponentSelector expressionSelector) {
        if (indicesOptions.allowSelectors()) {
            return expressionSelector == null || expressionSelector.shouldIncludeData();
        }
        return true;
    }

    public static boolean shouldIncludeFailureIndices(IndicesOptions indicesOptions, IndexComponentSelector expressionSelector) {
        if (indicesOptions.allowSelectors()) {
            return expressionSelector != null && expressionSelector.shouldIncludeFailures();
        }
        return indicesOptions.includeFailureIndices();
    }

    private static boolean resolvesToMoreThanOneIndex(IndexAbstraction indexAbstraction, Context context, ResolvedExpression expression) {
        if (indexAbstraction.getType() == IndexAbstraction.Type.ALIAS && indexAbstraction.isDataStreamRelated()) {
            SortedMap<String, IndexAbstraction> indicesLookup = context.state.metadata().getIndicesLookup();
            int count = 0;
            HashSet<DataStream> visitedDataStreams = new HashSet<DataStream>();
            List<Index> indices = indexAbstraction.getIndices();
            int n = indices.size();
            for (int i = 0; i < n; ++i) {
                Index index = indices.get(i);
                DataStream parentDataStream = ((IndexAbstraction)indicesLookup.get(index.getName())).getParentDataStream();
                if (parentDataStream == null || !visitedDataStreams.add(parentDataStream)) continue;
                if (IndexNameExpressionResolver.shouldIncludeRegularIndices(context.getOptions(), expression.selector())) {
                    count += parentDataStream.getIndices().size();
                }
                if (IndexNameExpressionResolver.shouldIncludeFailureIndices(context.getOptions(), expression.selector())) {
                    count += parentDataStream.getFailureIndices().size();
                }
                if (count <= 1) continue;
                return true;
            }
            return false;
        }
        if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM) {
            DataStream dataStream = (DataStream)indexAbstraction;
            int count = 0;
            if (IndexNameExpressionResolver.shouldIncludeRegularIndices(context.getOptions(), expression.selector())) {
                count += dataStream.getIndices().size();
            }
            if (IndexNameExpressionResolver.shouldIncludeFailureIndices(context.getOptions(), expression.selector())) {
                count += dataStream.getFailureIndices().size();
            }
            return count > 1;
        }
        return indexAbstraction.getIndices().size() > 1;
    }

    private static IndexNotFoundException notFoundException(String ... indexExpressions) {
        IndexNotFoundException infe;
        if (indexExpressions == null || indexExpressions.length == 0 || indexExpressions.length == 1 && "_all".equals(indexExpressions[0])) {
            infe = new IndexNotFoundException("no indices exist", "_all");
            infe.setResources("index_or_alias", "_all");
        } else if (indexExpressions.length == 1) {
            infe = indexExpressions[0].startsWith("-") ? new IndexNotFoundException("if you intended to exclude this index, ensure that you use wildcards that include it before explicitly excluding it", indexExpressions[0]) : new IndexNotFoundException(indexExpressions[0]);
            infe.setResources("index_or_alias", indexExpressions[0]);
        } else {
            infe = new IndexNotFoundException((String)null);
            infe.setResources("index_expression", indexExpressions);
        }
        return infe;
    }

    private static boolean shouldTrackConcreteIndex(Context context, Index index) {
        if (SystemResourceAccess.isNetNewInBackwardCompatibleMode(context, index)) {
            return false;
        }
        IndexMetadata imd = context.state.metadata().index(index);
        if (imd.getState() == IndexMetadata.State.CLOSE) {
            IndicesOptions options = context.getOptions();
            if (options.forbidClosedIndices() && !options.ignoreUnavailable()) {
                throw new IndexClosedException(index);
            }
            return !options.forbidClosedIndices() && IndexNameExpressionResolver.addIndex(index, imd, context);
        }
        if (imd.getState() == IndexMetadata.State.OPEN) {
            return IndexNameExpressionResolver.addIndex(index, imd, context);
        }
        throw new IllegalStateException("index state [" + String.valueOf(index) + "] not supported");
    }

    private static boolean addIndex(Index index, IndexMetadata imd, Context context) {
        if (context.options.ignoreThrottled()) {
            imd = imd != null ? imd : context.state.metadata().index(index);
            return imd.getSettings().getAsBoolean("index.frozen", false) == false;
        }
        return true;
    }

    private static IllegalArgumentException aliasesNotSupportedException(String expression) {
        return new IllegalArgumentException("The provided expression [" + expression + "] matches an alias, specify the corresponding concrete indices instead.");
    }

    public Index concreteSingleIndex(ClusterState state, IndicesRequest request) {
        String indexExpression = CollectionUtils.isEmpty(request.indices()) ? null : request.indices()[0];
        Index[] indices = this.concreteIndices(state, request.indicesOptions(), indexExpression);
        if (indices.length != 1) {
            throw new IllegalArgumentException("unable to return a single index as the index and options provided got resolved to multiple indices");
        }
        return indices[0];
    }

    public Index concreteWriteIndex(ClusterState state, IndicesRequest request) {
        if (request.indices() == null || request.indices() != null && request.indices().length != 1) {
            throw new IllegalArgumentException("indices request must specify a single index expression");
        }
        return this.concreteWriteIndex(state, request.indicesOptions(), request.indices()[0], false, request.includeDataStreams());
    }

    public Index concreteWriteIndex(ClusterState state, IndicesOptions options, String index, boolean allowNoIndices, boolean includeDataStreams) {
        IndicesOptions combinedOptions = IndicesOptions.fromOptions(options.ignoreUnavailable(), allowNoIndices, options.expandWildcardsOpen(), options.expandWildcardsClosed(), options.expandWildcardsHidden(), options.allowAliasesToMultipleIndices(), options.forbidClosedIndices(), options.ignoreAliases(), options.ignoreThrottled());
        Context context = new Context(state, combinedOptions, false, true, includeDataStreams, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        Index[] indices = this.concreteIndices(context, index);
        if (allowNoIndices && indices.length == 0) {
            return null;
        }
        if (indices.length != 1) {
            throw new IllegalArgumentException("The index expression [" + index + "] and options provided did not point to a single write-index");
        }
        return indices[0];
    }

    public boolean hasIndexAbstraction(String indexAbstraction, ClusterState state) {
        String resolvedAliasOrIndex = DateMathExpressionResolver.resolveExpression(indexAbstraction);
        return state.metadata().hasIndexAbstraction(resolvedAliasOrIndex);
    }

    public static boolean hasSelectorSuffix(String expression) {
        if (expression == null) {
            return false;
        }
        return expression.contains("::");
    }

    public static Tuple<String, String> splitSelectorExpression(String expression) {
        return SelectorResolver.splitSelectorExpression(expression, Tuple::new);
    }

    public static String combineSelector(String baseExpression, @Nullable IndexComponentSelector selectorExpression) {
        Objects.requireNonNull(baseExpression, "baseExpression is null");
        return selectorExpression == null || IndexComponentSelector.DATA.equals(selectorExpression) ? baseExpression : baseExpression + "::" + selectorExpression.getKey();
    }

    public static String combineSelectorExpression(String baseExpression, @Nullable String selectorExpression) {
        Objects.requireNonNull(baseExpression, "baseExpression is null");
        return selectorExpression == null || IndexComponentSelector.DATA.getKey().equals(selectorExpression) ? baseExpression : baseExpression + "::" + selectorExpression;
    }

    public Set<ResolvedExpression> resolveExpressions(ClusterState state, String ... expressions) {
        return this.resolveExpressions(state, IndicesOptions.lenientExpandOpen(), false, expressions);
    }

    public Set<ResolvedExpression> resolveExpressions(ClusterState state, IndicesOptions indicesOptions, boolean preserveDataStreams, String ... expressions) {
        Context context = new Context(state, indicesOptions, true, false, true, preserveDataStreams, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        Collection<ResolvedExpression> resolved = IndexNameExpressionResolver.resolveExpressionsToResources(context, expressions);
        if (resolved instanceof Set) {
            return Collections.unmodifiableSet((Set)resolved);
        }
        return Set.copyOf(resolved);
    }

    public String[] filteringAliases(ClusterState state, String index, Set<ResolvedExpression> resolvedExpressions) {
        return this.indexAliases(state, index, AliasMetadata::filteringRequired, DataStreamAlias::filteringRequired, false, resolvedExpressions);
    }

    boolean iterateIndexAliases(int indexAliasesSize, int resolvedExpressionsSize) {
        return indexAliasesSize <= resolvedExpressionsSize;
    }

    public String[] indexAliases(ClusterState state, String index, Predicate<AliasMetadata> requiredAlias, Predicate<DataStreamAlias> requiredDataStreamAlias, boolean skipIdentity, Set<ResolvedExpression> resolvedExpressions) {
        IndexAbstraction ia;
        DataStream dataStream;
        if (IndexNameExpressionResolver.isAllIndicesExpression(resolvedExpressions)) {
            return null;
        }
        IndexMetadata indexMetadata = state.metadata().getIndices().get(index);
        if (indexMetadata == null) {
            throw new IndexNotFoundException(index);
        }
        if (!skipIdentity) {
            if (resolvedExpressions.contains(new ResolvedExpression(index))) {
                return null;
            }
            for (IndexComponentSelector selector : IndexComponentSelector.values()) {
                if (!resolvedExpressions.contains(new ResolvedExpression(index, selector))) continue;
                return null;
            }
        }
        if ((dataStream = (ia = (IndexAbstraction)state.metadata().getIndicesLookup().get(index)).getParentDataStream()) != null) {
            if (dataStream.getFailureComponent().containsIndex(index)) {
                return null;
            }
            if (!skipIdentity && IndexNameExpressionResolver.resolvedExpressionsContainsAbstraction(resolvedExpressions, dataStream.getName())) {
                return null;
            }
            Map<String, DataStreamAlias> dataStreamAliases = state.metadata().dataStreamAliases();
            List<DataStreamAlias> aliasesForDataStream = this.iterateIndexAliases(dataStreamAliases.size(), resolvedExpressions.size()) ? dataStreamAliases.values().stream().filter(dataStreamAlias -> IndexNameExpressionResolver.resolvedExpressionsContainsAbstraction(resolvedExpressions, dataStreamAlias.getName())).filter(dataStreamAlias -> dataStreamAlias.getDataStreams().contains(dataStream.getName())).toList() : resolvedExpressions.stream().filter(expression -> expression.selector() == null || expression.selector().shouldIncludeData()).map(ResolvedExpression::resource).map(dataStreamAliases::get).filter(dataStreamAlias -> dataStreamAlias != null && dataStreamAlias.getDataStreams().contains(dataStream.getName())).toList();
            ArrayList<String> requiredAliases = null;
            for (DataStreamAlias dataStreamAlias2 : aliasesForDataStream) {
                if (requiredDataStreamAlias.test(dataStreamAlias2)) {
                    if (requiredAliases == null) {
                        requiredAliases = new ArrayList<String>(aliasesForDataStream.size());
                    }
                    requiredAliases.add(dataStreamAlias2.getName());
                    continue;
                }
                return null;
            }
            if (requiredAliases == null) {
                return null;
            }
            return requiredAliases.toArray(Strings.EMPTY_ARRAY);
        }
        Map<String, AliasMetadata> indexAliases = indexMetadata.getAliases();
        AliasMetadata[] aliasCandidates = this.iterateIndexAliases(indexAliases.size(), resolvedExpressions.size()) ? (AliasMetadata[])indexAliases.values().stream().filter(aliasMetadata -> IndexNameExpressionResolver.resolvedExpressionsContainsAbstraction(resolvedExpressions, aliasMetadata.alias())).toArray(AliasMetadata[]::new) : (AliasMetadata[])resolvedExpressions.stream().map(ResolvedExpression::resource).map(indexAliases::get).filter(Objects::nonNull).toArray(AliasMetadata[]::new);
        ArrayList<String> aliases = null;
        for (int i = 0; i < aliasCandidates.length; ++i) {
            AliasMetadata aliasMetadata2 = aliasCandidates[i];
            if (requiredAlias.test(aliasMetadata2)) {
                if (aliases == null) {
                    aliases = new ArrayList<String>();
                }
            } else {
                return null;
            }
            aliases.add(aliasMetadata2.alias());
        }
        if (aliases == null) {
            return null;
        }
        return aliases.toArray(Strings.EMPTY_ARRAY);
    }

    private static boolean resolvedExpressionsContainsAbstraction(Set<ResolvedExpression> resolvedExpressions, String abstractionName) {
        return resolvedExpressions.contains(new ResolvedExpression(abstractionName)) || resolvedExpressions.contains(new ResolvedExpression(abstractionName, IndexComponentSelector.DATA));
    }

    public Map<String, Set<String>> resolveSearchRouting(ClusterState state, @Nullable String routing, String ... expressions) {
        Context context = new Context(state, IndicesOptions.lenientExpandOpen(), false, false, true, this.getSystemIndexAccessLevel(), this.getSystemIndexAccessPredicate(), this.getNetNewSystemIndexPredicate());
        Collection<ResolvedExpression> resolvedExpressions = IndexNameExpressionResolver.resolveExpressionsToResources(context, expressions);
        Map<String, Set<String>> routings = null;
        HashSet<String> paramRouting = null;
        HashSet<String> norouting = new HashSet<String>();
        if (routing != null) {
            paramRouting = Sets.newHashSet(Strings.splitStringByCommaToArray(routing));
        }
        for (ResolvedExpression resolvedExpression : resolvedExpressions) {
            String concreteIndex;
            Index index;
            IndexAbstraction indexAbstraction = (IndexAbstraction)state.metadata().getIndicesLookup().get(resolvedExpression.resource());
            if (indexAbstraction != null && indexAbstraction.getType() == IndexAbstraction.Type.ALIAS) {
                ArrayList<Index> aliasIndices = null;
                if (context.getOptions().allowSelectors()) {
                    List<Index> failureIndices;
                    IndexComponentSelector selector = resolvedExpression.selector();
                    if (IndexNameExpressionResolver.shouldIncludeRegularIndices(context.getOptions(), selector)) {
                        aliasIndices = new ArrayList<Index>(indexAbstraction.getIndices().size());
                        aliasIndices.addAll(indexAbstraction.getIndices());
                    }
                    if (IndexNameExpressionResolver.shouldIncludeFailureIndices(context.getOptions(), selector) && indexAbstraction.isDataStreamRelated() && !(failureIndices = indexAbstraction.getFailureIndices(context.state.metadata())).isEmpty()) {
                        aliasIndices = aliasIndices == null ? new ArrayList<Index>(failureIndices.size()) : aliasIndices;
                        aliasIndices.addAll(failureIndices);
                    }
                    aliasIndices = aliasIndices == null ? List.of() : aliasIndices;
                } else {
                    aliasIndices = indexAbstraction.getIndices();
                }
                int n = aliasIndices.size();
                for (int i = 0; i < n; ++i) {
                    index = aliasIndices.get(i);
                    concreteIndex = index.getName();
                    if (norouting.contains(concreteIndex)) continue;
                    AliasMetadata aliasMetadata = state.metadata().index(concreteIndex).getAliases().get(indexAbstraction.getName());
                    if (aliasMetadata != null && !aliasMetadata.searchRoutingValues().isEmpty()) {
                        if (routings == null) {
                            routings = new HashMap<String, Set<String>>();
                        }
                        Set r = routings.computeIfAbsent(concreteIndex, k -> new HashSet());
                        r.addAll(aliasMetadata.searchRoutingValues());
                        if (paramRouting != null) {
                            r.retainAll(paramRouting);
                        }
                        if (!r.isEmpty()) continue;
                        routings.remove(concreteIndex);
                        continue;
                    }
                    routings = IndexNameExpressionResolver.collectRoutings(routings, paramRouting, norouting, concreteIndex);
                }
                continue;
            }
            if (indexAbstraction != null && indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM) {
                DataStream dataStream = (DataStream)indexAbstraction;
                if (!dataStream.isAllowCustomRouting()) continue;
                if (IndexNameExpressionResolver.shouldIncludeRegularIndices(context.getOptions(), resolvedExpression.selector()) && dataStream.getIndices() != null) {
                    int n = dataStream.getIndices().size();
                    for (int i = 0; i < n; ++i) {
                        index = dataStream.getIndices().get(i);
                        concreteIndex = index.getName();
                        routings = IndexNameExpressionResolver.collectRoutings(routings, paramRouting, norouting, concreteIndex);
                    }
                }
                if (!IndexNameExpressionResolver.shouldIncludeFailureIndices(context.getOptions(), resolvedExpression.selector()) || dataStream.getFailureIndices().isEmpty()) continue;
                for (Index failureIndex : dataStream.getFailureIndices()) {
                    String concreteIndex2 = failureIndex.getName();
                    routings = IndexNameExpressionResolver.collectRoutings(routings, paramRouting, norouting, concreteIndex2);
                }
                continue;
            }
            assert (resolvedExpression.selector() == null || IndexComponentSelector.DATA.equals(resolvedExpression.selector())) : "Concrete index is being resolved with a selector other than [data] which is illegal";
            routings = IndexNameExpressionResolver.collectRoutings(routings, paramRouting, norouting, resolvedExpression.resource());
        }
        if (routings == null || routings.isEmpty()) {
            return null;
        }
        return routings;
    }

    @Nullable
    private static Map<String, Set<String>> collectRoutings(@Nullable Map<String, Set<String>> routings, @Nullable Set<String> paramRouting, Set<String> noRouting, String concreteIndex) {
        if (noRouting.add(concreteIndex)) {
            if (paramRouting != null) {
                if (routings == null) {
                    routings = new HashMap<String, Set<String>>();
                }
                routings.put(concreteIndex, new HashSet<String>(paramRouting));
            } else if (routings != null) {
                routings.remove(concreteIndex);
            }
        }
        return routings;
    }

    public static Map<String, Set<String>> resolveSearchRoutingAllIndices(Metadata metadata, String routing) {
        if (routing != null) {
            HashSet<String> r = Sets.newHashSet(Strings.splitStringByCommaToArray(routing));
            HashMap<String, Set<String>> routings = new HashMap<String, Set<String>>();
            String[] concreteIndices = metadata.getConcreteAllIndices();
            for (int i = 0; i < concreteIndices.length; ++i) {
                routings.put(concreteIndices[i], r);
            }
            return routings;
        }
        return null;
    }

    public static boolean isAllIndicesExpression(Collection<ResolvedExpression> aliasesOrIndices) {
        return IndexNameExpressionResolver.isAllIndices(aliasesOrIndices, ResolvedExpression::resource);
    }

    public static boolean isAllIndices(Collection<String> aliasesOrIndices) {
        return IndexNameExpressionResolver.isAllIndices(aliasesOrIndices, Function.identity());
    }

    public static <T> boolean isAllIndices(Collection<T> aliasesOrIndices, Function<T, String> resourceGetter) {
        return aliasesOrIndices == null || aliasesOrIndices.isEmpty() || IndexNameExpressionResolver.isExplicitAllPattern(aliasesOrIndices, resourceGetter);
    }

    static boolean isExplicitAllPattern(Collection<String> aliasesOrIndices) {
        return IndexNameExpressionResolver.isExplicitAllPattern(aliasesOrIndices, Function.identity());
    }

    static <T> boolean isExplicitAllPattern(Collection<T> aliasesOrIndices, Function<T, String> resourceGetter) {
        return aliasesOrIndices != null && aliasesOrIndices.size() == 1 && "_all".equals(resourceGetter.apply(aliasesOrIndices.iterator().next()));
    }

    static boolean isNoneExpression(String[] expressions) {
        return expressions.length == 2 && "*".equals(expressions[0]) && "-*".equals(expressions[1]);
    }

    public SystemIndices.SystemIndexAccessLevel getSystemIndexAccessLevel() {
        SystemIndices.SystemIndexAccessLevel accessLevel = SystemIndices.getSystemIndexAccessLevel(this.threadContext);
        assert (accessLevel != SystemIndices.SystemIndexAccessLevel.BACKWARDS_COMPATIBLE_ONLY) : "BACKWARDS_COMPATIBLE_ONLY access level should never be used automatically, it should only be used in known special cases";
        return accessLevel;
    }

    public Predicate<String> getSystemIndexAccessPredicate() {
        SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel = this.getSystemIndexAccessLevel();
        Predicate<String> systemIndexAccessLevelPredicate = systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.NONE ? Predicates.never() : (systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.BACKWARDS_COMPATIBLE_ONLY ? this.getNetNewSystemIndexPredicate() : (systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.ALL ? Predicates.always() : this.systemIndices.getProductSystemIndexNamePredicate(this.threadContext)));
        return systemIndexAccessLevelPredicate;
    }

    public Automaton getSystemNameAutomaton() {
        return this.systemIndices.getSystemNameAutomaton();
    }

    public Predicate<String> getNetNewSystemIndexPredicate() {
        return this.systemIndices::isNetNewSystemIndex;
    }

    @Nullable
    private static boolean ensureAliasOrIndexExists(Context context, String name, IndexComponentSelector selector) {
        boolean ignoreUnavailable = context.getOptions().ignoreUnavailable();
        IndexAbstraction indexAbstraction = (IndexAbstraction)context.getState().getMetadata().getIndicesLookup().get(name);
        if (indexAbstraction == null) {
            if (ignoreUnavailable) {
                return false;
            }
            throw IndexNameExpressionResolver.notFoundException(name);
        }
        if (indexAbstraction.getType() == IndexAbstraction.Type.ALIAS && context.getOptions().ignoreAliases()) {
            if (ignoreUnavailable) {
                return false;
            }
            throw IndexNameExpressionResolver.aliasesNotSupportedException(name);
        }
        if (indexAbstraction.isDataStreamRelated() && !context.includeDataStreams()) {
            if (ignoreUnavailable) {
                return false;
            }
            IndexNotFoundException infe = IndexNameExpressionResolver.notFoundException(name);
            infe.addMetadata(EXCLUDED_DATA_STREAMS_KEY, "true");
            throw infe;
        }
        if (context.options.allowSelectors()) {
            assert (selector != null) : "Earlier logic should have parsed selectors or added the default selectors already";
            if (IndexComponentSelector.FAILURES.equals(selector) && !indexAbstraction.isDataStreamRelated()) {
                if (ignoreUnavailable) {
                    return false;
                }
                throw IndexNameExpressionResolver.notFoundException(IndexNameExpressionResolver.combineSelector(name, selector));
            }
        }
        return true;
    }

    public static String resolveDateMathExpression(String dateExpression) {
        return DateMathExpressionResolver.resolveExpression(dateExpression);
    }

    public static String resolveDateMathExpression(String dateExpression, long time) {
        return DateMathExpressionResolver.resolveExpression(dateExpression, () -> time);
    }

    public static class Context {
        private final ClusterState state;
        private final IndicesOptions options;
        private final long startTime;
        private final boolean preserveAliases;
        private final boolean resolveToWriteIndex;
        private final boolean includeDataStreams;
        private final boolean preserveDataStreams;
        private final SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel;
        private final Predicate<String> systemIndexAccessPredicate;
        private final Predicate<String> netNewSystemIndexPredicate;

        Context(ClusterState state, IndicesOptions options, SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel) {
            this(state, options, systemIndexAccessLevel, Predicates.always(), Predicates.never());
        }

        Context(ClusterState state, IndicesOptions options, SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel, Predicate<String> systemIndexAccessPredicate, Predicate<String> netNewSystemIndexPredicate) {
            this(state, options, System.currentTimeMillis(), systemIndexAccessLevel, systemIndexAccessPredicate, netNewSystemIndexPredicate);
        }

        Context(ClusterState state, IndicesOptions options, boolean preserveAliases, boolean resolveToWriteIndex, boolean includeDataStreams, SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel, Predicate<String> systemIndexAccessPredicate, Predicate<String> netNewSystemIndexPredicate) {
            this(state, options, System.currentTimeMillis(), preserveAliases, resolveToWriteIndex, includeDataStreams, false, systemIndexAccessLevel, systemIndexAccessPredicate, netNewSystemIndexPredicate);
        }

        Context(ClusterState state, IndicesOptions options, boolean preserveAliases, boolean resolveToWriteIndex, boolean includeDataStreams, boolean preserveDataStreams, SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel, Predicate<String> systemIndexAccessPredicate, Predicate<String> netNewSystemIndexPredicate) {
            this(state, options, System.currentTimeMillis(), preserveAliases, resolveToWriteIndex, includeDataStreams, preserveDataStreams, systemIndexAccessLevel, systemIndexAccessPredicate, netNewSystemIndexPredicate);
        }

        Context(ClusterState state, IndicesOptions options, long startTime, SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel, Predicate<String> systemIndexAccessPredicate, Predicate<String> netNewSystemIndexPredicate) {
            this(state, options, startTime, false, false, false, false, systemIndexAccessLevel, systemIndexAccessPredicate, netNewSystemIndexPredicate);
        }

        protected Context(ClusterState state, IndicesOptions options, long startTime, boolean preserveAliases, boolean resolveToWriteIndex, boolean includeDataStreams, boolean preserveDataStreams, SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel, Predicate<String> systemIndexAccessPredicate, Predicate<String> netNewSystemIndexPredicate) {
            this.state = state;
            this.options = options;
            this.startTime = startTime;
            this.preserveAliases = preserveAliases;
            this.resolveToWriteIndex = resolveToWriteIndex;
            this.includeDataStreams = includeDataStreams;
            this.preserveDataStreams = preserveDataStreams;
            this.systemIndexAccessLevel = systemIndexAccessLevel;
            this.systemIndexAccessPredicate = systemIndexAccessPredicate;
            this.netNewSystemIndexPredicate = netNewSystemIndexPredicate;
        }

        public ClusterState getState() {
            return this.state;
        }

        public IndicesOptions getOptions() {
            return this.options;
        }

        public long getStartTime() {
            return this.startTime;
        }

        boolean isPreserveAliases() {
            return this.preserveAliases;
        }

        boolean isResolveToWriteIndex() {
            return this.resolveToWriteIndex;
        }

        public boolean includeDataStreams() {
            return this.includeDataStreams;
        }

        public boolean isPreserveDataStreams() {
            return this.preserveDataStreams;
        }

        public Predicate<String> getSystemIndexAccessPredicate() {
            return this.systemIndexAccessPredicate;
        }
    }

    public record ResolvedExpression(String resource, @Nullable IndexComponentSelector selector) {
        public ResolvedExpression(String indexAbstraction) {
            this(indexAbstraction, (IndexComponentSelector)null);
        }

        public ResolvedExpression(String indexAbstraction, IndicesOptions options) {
            this(indexAbstraction, options.allowSelectors() ? IndexComponentSelector.DATA : null);
        }

        public String combined() {
            return IndexNameExpressionResolver.combineSelector(this.resource, this.selector);
        }
    }

    public static final class SystemResourceAccess {
        private SystemResourceAccess() {
        }

        public static boolean isSystemIndexAbstractionAccessible(Context context, IndexAbstraction abstraction) {
            assert (abstraction.isSystem()) : "We should only check this for system resources";
            if (context.netNewSystemIndexPredicate.test(abstraction.getName())) {
                if (SystemIndices.SystemIndexAccessLevel.BACKWARDS_COMPATIBLE_ONLY.equals((Object)context.systemIndexAccessLevel)) {
                    return false;
                }
                return context.systemIndexAccessPredicate.test(abstraction.getName());
            }
            if (abstraction.getType() == IndexAbstraction.Type.DATA_STREAM || abstraction.getParentDataStream() != null) {
                return context.systemIndexAccessPredicate.test(abstraction.getName());
            }
            return true;
        }

        private static boolean shouldExpandToSystemIndexAbstraction(Context context, IndexAbstraction indexAbstraction) {
            assert (indexAbstraction.isSystem()) : "We should only check this for system resources";
            boolean isHistoric = indexAbstraction.getType() != IndexAbstraction.Type.DATA_STREAM && indexAbstraction.getParentDataStream() == null && !context.netNewSystemIndexPredicate.test(indexAbstraction.getName());
            return isHistoric || context.systemIndexAccessPredicate.test(indexAbstraction.getName());
        }

        private static void checkSystemIndexAccess(Context context, ThreadContext threadContext, Index ... concreteIndices) {
            Predicate<String> systemIndexAccessPredicate = context.getSystemIndexAccessPredicate();
            if (systemIndexAccessPredicate == Predicates.always()) {
                return;
            }
            SystemResourceAccess.doCheckSystemIndexAccess(context, systemIndexAccessPredicate, threadContext, concreteIndices);
        }

        private static void doCheckSystemIndexAccess(Context context, Predicate<String> systemIndexAccessPredicate, ThreadContext threadContext, Index ... concreteIndices) {
            Metadata metadata = context.getState().metadata();
            ArrayList<String> resolvedSystemIndices = new ArrayList<String>();
            ArrayList<String> resolvedNetNewSystemIndices = new ArrayList<String>();
            HashSet<String> resolvedSystemDataStreams = new HashSet<String>();
            SortedMap<String, IndexAbstraction> indicesLookup = metadata.getIndicesLookup();
            boolean matchedIndex = false;
            for (int i = 0; i < concreteIndices.length; ++i) {
                Index concreteIndex = concreteIndices[i];
                IndexMetadata idxMetadata = metadata.index(concreteIndex);
                String name = concreteIndex.getName();
                if (!idxMetadata.isSystem() || systemIndexAccessPredicate.test(name)) continue;
                matchedIndex = true;
                IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(name);
                if (indexAbstraction.getParentDataStream() != null) {
                    resolvedSystemDataStreams.add(indexAbstraction.getParentDataStream().getName());
                    continue;
                }
                if (context.netNewSystemIndexPredicate.test(name)) {
                    resolvedNetNewSystemIndices.add(name);
                    continue;
                }
                resolvedSystemIndices.add(name);
            }
            if (matchedIndex) {
                SystemResourceAccess.handleMatchedSystemIndices(resolvedSystemIndices, resolvedSystemDataStreams, resolvedNetNewSystemIndices, threadContext);
            }
        }

        private static void handleMatchedSystemIndices(List<String> resolvedSystemIndices, Set<String> resolvedSystemDataStreams, List<String> resolvedNetNewSystemIndices, ThreadContext threadContext) {
            if (!resolvedSystemIndices.isEmpty()) {
                Collections.sort(resolvedSystemIndices);
                deprecationLogger.warn(DeprecationCategory.API, "open_system_index_access", "this request accesses system indices: {}, but in a future major version, direct access to system indices will be prevented by default", resolvedSystemIndices);
            }
            if (!resolvedSystemDataStreams.isEmpty()) {
                throw SystemIndices.dataStreamAccessException(threadContext, resolvedSystemDataStreams);
            }
            if (!resolvedNetNewSystemIndices.isEmpty()) {
                throw SystemIndices.netNewSystemIndexAccessException(threadContext, resolvedNetNewSystemIndices);
            }
        }

        private static boolean isNetNewInBackwardCompatibleMode(Context context, Index index) {
            return context.systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.BACKWARDS_COMPATIBLE_ONLY && context.netNewSystemIndexPredicate.test(index.getName());
        }
    }

    public static final class SelectorResolver {
        public static final String SELECTOR_SEPARATOR = "::";

        private SelectorResolver() {
        }

        public static ResolvedExpression parseExpression(String expression, IndicesOptions options) {
            return SelectorResolver.parseAndTransformSelector(expression, (baseExpression, selector) -> {
                if (options.allowSelectors()) {
                    IndexComponentSelector resolvedSelector = selector != null ? selector : IndexComponentSelector.DATA;
                    return new ResolvedExpression((String)baseExpression, resolvedSelector);
                }
                SelectorResolver.ensureNoSelectorsProvided(expression, selector);
                return new ResolvedExpression((String)baseExpression);
            });
        }

        public static IndexComponentSelector parseMatchAllToSelector(Context context, String matchAllExpression) {
            return SelectorResolver.parseAndTransformSelector(matchAllExpression, (baseExpression, selector) -> {
                if (context.options.allowSelectors()) {
                    return selector == null ? IndexComponentSelector.DATA : selector;
                }
                SelectorResolver.ensureNoSelectorsProvided(matchAllExpression, selector);
                return null;
            });
        }

        private static boolean selectorsValidatedAndMatchesPredicate(String expression, Context context, Predicate<String> predicate) {
            if (expression == null) {
                return false;
            }
            return SelectorResolver.parseAndTransformSelector(expression, (base, selectors) -> {
                if (!context.options.allowSelectors()) {
                    SelectorResolver.ensureNoSelectorsProvided(expression, selectors);
                }
                return predicate.test((String)base);
            });
        }

        private static <V> V parseAndTransformSelector(String expression, BiFunction<String, IndexComponentSelector, V> bindFunction) {
            return (V)SelectorResolver.splitSelectorExpression(expression, (expressionBase, suffix) -> {
                if (suffix == null) {
                    return bindFunction.apply((String)expressionBase, (IndexComponentSelector)null);
                }
                return bindFunction.apply((String)expressionBase, IndexComponentSelector.getByKey(suffix));
            });
        }

        private static <V> V splitSelectorExpression(String expression, BiFunction<String, String, V> bindFunction) {
            Objects.requireNonNull(expression, "expression cannot be null");
            int lastDoubleColon = expression.lastIndexOf(SELECTOR_SEPARATOR);
            if (lastDoubleColon >= 0) {
                String suffix = expression.substring(lastDoubleColon + SELECTOR_SEPARATOR.length());
                IndexComponentSelector selector = IndexComponentSelector.getByKey(suffix);
                if (selector == null) {
                    throw new InvalidIndexNameException(expression, "invalid usage of :: separator, [" + suffix + "] is not a recognized selector");
                }
                String expressionBase = expression.substring(0, lastDoubleColon);
                SelectorResolver.ensureNoMoreSelectorSeparators(expressionBase, expression);
                return bindFunction.apply(expressionBase, suffix);
            }
            return bindFunction.apply(expression, null);
        }

        private static void ensureNoSelectorsProvided(String expression, IndexComponentSelector selector) {
            if (selector != null) {
                throw new IllegalArgumentException("Index component selectors are not supported in this context but found selector in expression [" + expression + "]");
            }
        }

        private static void ensureNoMoreSelectorSeparators(String remainingExpression, String originalExpression) {
            if (remainingExpression.contains(SELECTOR_SEPARATOR)) {
                throw new InvalidIndexNameException(originalExpression, "Invalid usage of :: separator, only one :: separator is allowed per expression");
            }
        }
    }

    static final class WildcardExpressionResolver {
        private WildcardExpressionResolver() {
        }

        public static Collection<ResolvedExpression> resolveAll(Context context, IndexComponentSelector selector) {
            assert (selector != null || !context.options.allowSelectors()) : "selectors are enabled in this context, but a selector was not provided";
            List<ResolvedExpression> concreteIndices = WildcardExpressionResolver.resolveEmptyOrTrivialWildcard(context, selector);
            if (!context.includeDataStreams() && context.getOptions().ignoreAliases()) {
                return concreteIndices;
            }
            HashSet<ResolvedExpression> resolved = new HashSet<ResolvedExpression>(concreteIndices.size());
            context.getState().metadata().getIndicesLookup().values().stream().filter(ia -> context.getOptions().expandWildcardsHidden() || !ia.isHidden()).filter(ia -> WildcardExpressionResolver.shouldIncludeIfDataStream(ia, context) || WildcardExpressionResolver.shouldIncludeIfAlias(ia, context)).filter(ia -> !ia.isSystem() || context.systemIndexAccessPredicate.test(ia.getName())).forEach(ia -> resolved.addAll(WildcardExpressionResolver.expandToOpenClosed(context, ia, selector)));
            resolved.addAll(concreteIndices);
            return resolved;
        }

        private static boolean shouldIncludeIfDataStream(IndexAbstraction ia, Context context) {
            return context.includeDataStreams() && ia.getType() == IndexAbstraction.Type.DATA_STREAM;
        }

        private static boolean shouldIncludeIfAlias(IndexAbstraction ia, Context context) {
            return !context.getOptions().ignoreAliases() && ia.getType() == IndexAbstraction.Type.ALIAS;
        }

        private static IndexMetadata.State excludeState(IndicesOptions options) {
            IndexMetadata.State excludeState;
            if (options.expandWildcardsOpen() && options.expandWildcardsClosed()) {
                excludeState = null;
            } else if (options.expandWildcardsOpen() && !options.expandWildcardsClosed()) {
                excludeState = IndexMetadata.State.CLOSE;
            } else if (options.expandWildcardsClosed() && !options.expandWildcardsOpen()) {
                excludeState = IndexMetadata.State.OPEN;
            } else {
                assert (false) : "this shouldn't get called if wildcards expand to none";
                excludeState = null;
            }
            return excludeState;
        }

        static Set<ResolvedExpression> matchWildcardToResources(Context context, String wildcardExpression, IndexComponentSelector selector) {
            assert (WildcardExpressionResolver.isWildcard(wildcardExpression));
            SortedMap<String, IndexAbstraction> indicesLookup = context.getState().getMetadata().getIndicesLookup();
            HashSet<ResolvedExpression> matchedResources = new HashSet<ResolvedExpression>();
            if (Regex.isSuffixMatchPattern(wildcardExpression)) {
                for (IndexAbstraction ia : WildcardExpressionResolver.filterIndicesLookupForSuffixWildcard(indicesLookup, wildcardExpression).values()) {
                    WildcardExpressionResolver.maybeAddToResult(context, wildcardExpression, ia, selector, matchedResources);
                }
                return matchedResources;
            }
            if (Regex.isMatchAllPattern(wildcardExpression)) {
                for (IndexAbstraction ia : indicesLookup.values()) {
                    WildcardExpressionResolver.maybeAddToResult(context, wildcardExpression, ia, selector, matchedResources);
                }
                return matchedResources;
            }
            for (IndexAbstraction indexAbstraction : indicesLookup.values()) {
                if (!Regex.simpleMatch(wildcardExpression, indexAbstraction.getName())) continue;
                WildcardExpressionResolver.maybeAddToResult(context, wildcardExpression, indexAbstraction, selector, matchedResources);
            }
            return matchedResources;
        }

        private static void maybeAddToResult(Context context, String wildcardExpression, IndexAbstraction indexAbstraction, @Nullable IndexComponentSelector selector, Set<ResolvedExpression> matchedResources) {
            if (WildcardExpressionResolver.shouldExpandToIndexAbstraction(context, wildcardExpression, indexAbstraction)) {
                matchedResources.addAll(WildcardExpressionResolver.expandToOpenClosed(context, indexAbstraction, selector));
            }
        }

        private static boolean shouldExpandToIndexAbstraction(Context context, String wildcardExpression, IndexAbstraction indexAbstraction) {
            if (context.getOptions().ignoreAliases() && indexAbstraction.getType() == IndexAbstraction.Type.ALIAS) {
                return false;
            }
            if (!context.includeDataStreams() && indexAbstraction.isDataStreamRelated()) {
                return false;
            }
            if (indexAbstraction.isSystem() && !SystemResourceAccess.shouldExpandToSystemIndexAbstraction(context, indexAbstraction)) {
                return false;
            }
            return context.getOptions().expandWildcardsHidden() || !indexAbstraction.isHidden() || wildcardExpression.startsWith(".") && indexAbstraction.getName().startsWith(".");
        }

        private static Map<String, IndexAbstraction> filterIndicesLookupForSuffixWildcard(SortedMap<String, IndexAbstraction> indicesLookup, String suffixWildcardExpression) {
            assert (Regex.isSuffixMatchPattern(suffixWildcardExpression));
            String fromPrefix = suffixWildcardExpression.substring(0, suffixWildcardExpression.length() - 1);
            char[] toPrefixCharArr = fromPrefix.toCharArray();
            int n = toPrefixCharArr.length - 1;
            toPrefixCharArr[n] = (char)(toPrefixCharArr[n] + '\u0001');
            String toPrefix = new String(toPrefixCharArr);
            return indicesLookup.subMap(fromPrefix, toPrefix);
        }

        private static Set<ResolvedExpression> expandToOpenClosed(Context context, IndexAbstraction indexAbstraction, IndexComponentSelector selector) {
            IndexMetadata.State excludeState = WildcardExpressionResolver.excludeState(context.getOptions());
            HashSet<ResolvedExpression> resources = new HashSet<ResolvedExpression>();
            if (context.isPreserveAliases() && indexAbstraction.getType() == IndexAbstraction.Type.ALIAS) {
                resources.add(new ResolvedExpression(indexAbstraction.getName(), selector));
            } else if (context.isPreserveDataStreams() && indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM) {
                resources.add(new ResolvedExpression(indexAbstraction.getName(), selector));
            } else {
                if (IndexNameExpressionResolver.shouldIncludeRegularIndices(context.getOptions(), selector)) {
                    int n = indexAbstraction.getIndices().size();
                    for (int i = 0; i < n; ++i) {
                        Index index = indexAbstraction.getIndices().get(i);
                        IndexMetadata indexMetadata = context.state.metadata().index(index);
                        if (indexMetadata.getState() == excludeState) continue;
                        resources.add(new ResolvedExpression(index.getName(), context.getOptions()));
                    }
                }
                if (IndexNameExpressionResolver.shouldIncludeFailureIndices(context.getOptions(), selector) && indexAbstraction.isDataStreamRelated()) {
                    List<Index> failureIndices = indexAbstraction.getFailureIndices(context.state.metadata());
                    int n = failureIndices.size();
                    for (int i = 0; i < n; ++i) {
                        Index index = failureIndices.get(i);
                        IndexMetadata indexMetadata = context.state.metadata().index(index);
                        if (indexMetadata.getState() == excludeState) continue;
                        resources.add(new ResolvedExpression(index.getName(), context.getOptions()));
                    }
                }
            }
            return resources;
        }

        private static List<ResolvedExpression> resolveEmptyOrTrivialWildcard(Context context, IndexComponentSelector selector) {
            String[] allIndices = WildcardExpressionResolver.resolveEmptyOrTrivialWildcardToAllIndices(context.getOptions(), context.getState().metadata(), selector);
            List<String> indices = context.systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.ALL ? List.of(allIndices) : WildcardExpressionResolver.resolveEmptyOrTrivialWildcardWithAllowedSystemIndices(context, allIndices);
            ArrayList<ResolvedExpression> result = new ArrayList<ResolvedExpression>(indices.size());
            boolean allowSelectors = context.options.allowSelectors();
            for (int i = 0; i < indices.size(); ++i) {
                if (allowSelectors) {
                    result.add(new ResolvedExpression(indices.get(i), IndexComponentSelector.DATA));
                    continue;
                }
                result.add(new ResolvedExpression(indices.get(i)));
            }
            return result;
        }

        private static List<String> resolveEmptyOrTrivialWildcardWithAllowedSystemIndices(Context context, String[] allIndices) {
            ArrayList<String> filteredIndices = new ArrayList<String>(allIndices.length);
            for (int i = 0; i < allIndices.length; ++i) {
                if (!WildcardExpressionResolver.shouldIncludeIndexAbstraction(context, allIndices[i])) continue;
                filteredIndices.add(allIndices[i]);
            }
            return filteredIndices;
        }

        private static boolean shouldIncludeIndexAbstraction(Context context, String name) {
            if (!name.startsWith(".")) {
                return true;
            }
            IndexAbstraction abstraction = (IndexAbstraction)context.state.metadata().getIndicesLookup().get(name);
            assert (abstraction != null) : "null abstraction for " + name + " but was in array of all indices";
            if (!abstraction.isSystem()) {
                return true;
            }
            return SystemResourceAccess.isSystemIndexAbstractionAccessible(context, abstraction);
        }

        private static String[] resolveEmptyOrTrivialWildcardToAllIndices(IndicesOptions options, Metadata metadata, IndexComponentSelector selector) {
            if (selector != null && !selector.shouldIncludeData()) {
                return Strings.EMPTY_ARRAY;
            }
            if (options.expandWildcardsOpen() && options.expandWildcardsClosed() && options.expandWildcardsHidden()) {
                return metadata.getConcreteAllIndices();
            }
            if (options.expandWildcardsOpen() && options.expandWildcardsClosed()) {
                return metadata.getConcreteVisibleIndices();
            }
            if (options.expandWildcardsOpen() && options.expandWildcardsHidden()) {
                return metadata.getConcreteAllOpenIndices();
            }
            if (options.expandWildcardsOpen()) {
                return metadata.getConcreteVisibleOpenIndices();
            }
            if (options.expandWildcardsClosed() && options.expandWildcardsHidden()) {
                return metadata.getConcreteAllClosedIndices();
            }
            if (options.expandWildcardsClosed()) {
                return metadata.getConcreteVisibleClosedIndices();
            }
            return Strings.EMPTY_ARRAY;
        }

        static boolean isWildcard(String expression) {
            return Regex.isSimpleMatchPattern(expression);
        }

        static boolean hasWildcards(String[] expressions) {
            for (int i = 0; i < expressions.length; ++i) {
                if (!WildcardExpressionResolver.isWildcard(expressions[i])) continue;
                return true;
            }
            return false;
        }
    }

    public static final class DateMathExpressionResolver {
        private static final DateFormatter DEFAULT_DATE_FORMATTER = DateFormatter.forPattern("uuuu.MM.dd");
        private static final String EXPRESSION_LEFT_BOUND = "<";
        private static final String EXPRESSION_RIGHT_BOUND = ">";
        private static final char LEFT_BOUND = '{';
        private static final char RIGHT_BOUND = '}';
        private static final char ESCAPE_CHAR = '\\';
        private static final char TIME_ZONE_BOUND = '|';

        private DateMathExpressionResolver() {
        }

        public static String resolveExpression(String expression) {
            return DateMathExpressionResolver.resolveExpression(expression, System::currentTimeMillis);
        }

        public static String resolveExpression(String expression, LongSupplier getTime) {
            if (!expression.startsWith(EXPRESSION_LEFT_BOUND) || !expression.endsWith(EXPRESSION_RIGHT_BOUND)) {
                return expression;
            }
            return DateMathExpressionResolver.doResolveExpression(expression, getTime);
        }

        private static String doResolveExpression(String expression, LongSupplier getTime) {
            boolean escape = false;
            boolean inDateFormat = false;
            boolean inPlaceHolder = false;
            StringBuilder beforePlaceHolderSb = new StringBuilder();
            StringBuilder inPlaceHolderSb = new StringBuilder();
            char[] text = expression.toCharArray();
            boolean from = true;
            int length = text.length - 1;
            block8: for (int i = 1; i < length; ++i) {
                char c;
                boolean escapedChar = escape;
                if (escape) {
                    escape = false;
                }
                if ((c = text[i]) == '\\') {
                    if (escapedChar) {
                        beforePlaceHolderSb.append(c);
                        escape = false;
                        continue;
                    }
                    escape = true;
                    continue;
                }
                if (inPlaceHolder) {
                    switch (c) {
                        case '{': {
                            if (inDateFormat && escapedChar) {
                                inPlaceHolderSb.append(c);
                                break;
                            }
                            if (!inDateFormat) {
                                inDateFormat = true;
                                inPlaceHolderSb.append(c);
                                break;
                            }
                            throw new ElasticsearchParseException("invalid dynamic name expression [{}]. invalid character in placeholder at position [{}]", new String(text, 1, length), i);
                        }
                        case '}': {
                            ZoneId timeZone;
                            DateFormatter dateFormatter;
                            String mathExpression;
                            if (inDateFormat && escapedChar) {
                                inPlaceHolderSb.append(c);
                                break;
                            }
                            if (inDateFormat) {
                                inDateFormat = false;
                                inPlaceHolderSb.append(c);
                                break;
                            }
                            String inPlaceHolderString = inPlaceHolderSb.toString();
                            int dateTimeFormatLeftBoundIndex = inPlaceHolderString.indexOf(123);
                            if (dateTimeFormatLeftBoundIndex < 0) {
                                mathExpression = inPlaceHolderString;
                                dateFormatter = DEFAULT_DATE_FORMATTER;
                                timeZone = ZoneOffset.UTC;
                            } else {
                                String dateFormatterPattern;
                                if (inPlaceHolderString.lastIndexOf(125) != inPlaceHolderString.length() - 1) {
                                    throw new ElasticsearchParseException("invalid dynamic name expression [{}]. missing closing `}` for date math format", inPlaceHolderString);
                                }
                                if (dateTimeFormatLeftBoundIndex == inPlaceHolderString.length() - 2) {
                                    throw new ElasticsearchParseException("invalid dynamic name expression [{}]. missing date format", inPlaceHolderString);
                                }
                                mathExpression = inPlaceHolderString.substring(0, dateTimeFormatLeftBoundIndex);
                                String patternAndTZid = inPlaceHolderString.substring(dateTimeFormatLeftBoundIndex + 1, inPlaceHolderString.length() - 1);
                                int formatPatternTimeZoneSeparatorIndex = patternAndTZid.indexOf(124);
                                if (formatPatternTimeZoneSeparatorIndex != -1) {
                                    dateFormatterPattern = patternAndTZid.substring(0, formatPatternTimeZoneSeparatorIndex);
                                    timeZone = DateUtils.of(patternAndTZid.substring(formatPatternTimeZoneSeparatorIndex + 1));
                                } else {
                                    dateFormatterPattern = patternAndTZid;
                                    timeZone = ZoneOffset.UTC;
                                }
                                dateFormatter = DateFormatter.forPattern(dateFormatterPattern);
                            }
                            DateFormatter formatter = dateFormatter.withZone(timeZone);
                            DateMathParser dateMathParser = formatter.toDateMathParser();
                            Instant instant = dateMathParser.parse(mathExpression, getTime, false, timeZone);
                            String time = formatter.format(instant);
                            beforePlaceHolderSb.append(time);
                            inPlaceHolderSb = new StringBuilder();
                            inPlaceHolder = false;
                            break;
                        }
                        default: {
                            inPlaceHolderSb.append(c);
                            break;
                        }
                    }
                    continue;
                }
                switch (c) {
                    case '{': {
                        if (escapedChar) {
                            beforePlaceHolderSb.append(c);
                            continue block8;
                        }
                        inPlaceHolder = true;
                        continue block8;
                    }
                    case '}': {
                        if (!escapedChar) {
                            throw new ElasticsearchParseException("invalid dynamic name expression [{}]. invalid character at position [{}]. `{` and `}` are reserved characters and should be escaped when used as part of the index name using `\\` (e.g. `\\{text\\}`)", new String(text, 1, length), i);
                        }
                    }
                    default: {
                        beforePlaceHolderSb.append(c);
                    }
                }
            }
            if (inPlaceHolder) {
                throw new ElasticsearchParseException("invalid dynamic name expression [{}]. date math placeholder is open ended", new String(text, 1, length));
            }
            if (beforePlaceHolderSb.length() == 0) {
                throw new ElasticsearchParseException("nothing captured", new Object[0]);
            }
            return beforePlaceHolderSb.toString();
        }
    }
}

