/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.Releasable;

public abstract class LocalMasterServiceTask
implements ClusterStateTaskListener {
    private final Priority priority;

    public LocalMasterServiceTask(Priority priority) {
        this.priority = priority;
    }

    protected void execute(ClusterState currentState) {
    }

    protected void onPublicationComplete() {
    }

    public void submit(MasterService masterService, String source) {
        masterService.createTaskQueue("local-master-service-task", this.priority, new ClusterStateTaskExecutor<LocalMasterServiceTask>(){

            @Override
            public boolean runOnlyOnMaster() {
                return false;
            }

            @Override
            public String describeTasks(List<LocalMasterServiceTask> tasks) {
                return "";
            }

            @Override
            public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<LocalMasterServiceTask> batchExecutionContext) {
                LocalMasterServiceTask thisTask = LocalMasterServiceTask.this;
                List<ClusterStateTaskExecutor.TaskContext<LocalMasterServiceTask>> taskContexts = batchExecutionContext.taskContexts();
                assert (taskContexts.size() == 1 && taskContexts.get(0).getTask() == thisTask) : "expected one-element task list containing current object but was " + String.valueOf(taskContexts);
                try (Releasable ignored = taskContexts.get(0).captureResponseHeaders();){
                    thisTask.execute(batchExecutionContext.initialState());
                }
                taskContexts.get(0).success(() -> LocalMasterServiceTask.this.onPublicationComplete());
                return batchExecutionContext.initialState();
            }
        }).submitTask(source, this, null);
    }
}

