/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharConsumer;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharSpliterator;
import it.unimi.dsi.fastutil.ints.AbstractInt2CharMap;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2CharArrayMap;
import it.unimi.dsi.fastutil.ints.Int2CharMap;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSpliterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSpliterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

public class Int2CharArrayMap
extends AbstractInt2CharMap
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected transient int[] key;
    protected transient char[] value;
    protected int size;
    protected transient Int2CharMap.FastEntrySet entries;
    protected transient IntSet keys;
    protected transient CharCollection values;

    public Int2CharArrayMap(int[] key, char[] value) {
        this.key = key;
        this.value = value;
        this.size = key.length;
        if (key.length != value.length) {
            throw new IllegalArgumentException("Keys and values have different lengths (" + key.length + ", " + value.length + ")");
        }
    }

    public Int2CharArrayMap() {
        this.key = IntArrays.EMPTY_ARRAY;
        this.value = CharArrays.EMPTY_ARRAY;
    }

    public Int2CharArrayMap(int capacity) {
        this.key = new int[capacity];
        this.value = new char[capacity];
    }

    public Int2CharArrayMap(Int2CharMap m) {
        this(m.size());
        int i = 0;
        for (Int2CharMap.Entry e : m.int2CharEntrySet()) {
            this.key[i] = e.getIntKey();
            this.value[i] = e.getCharValue();
            ++i;
        }
        this.size = i;
    }

    public Int2CharArrayMap(Map<? extends Integer, ? extends Character> m) {
        this(m.size());
        int i = 0;
        for (Map.Entry<? extends Integer, ? extends Character> e : m.entrySet()) {
            this.key[i] = e.getKey();
            this.value[i] = e.getValue().charValue();
            ++i;
        }
        this.size = i;
    }

    public Int2CharArrayMap(int[] key, char[] value, int size) {
        this.key = key;
        this.value = value;
        this.size = size;
        if (key.length != value.length) {
            throw new IllegalArgumentException("Keys and values have different lengths (" + key.length + ", " + value.length + ")");
        }
        if (size > key.length) {
            throw new IllegalArgumentException("The provided size (" + size + ") is larger than or equal to the backing-arrays size (" + key.length + ")");
        }
    }

    public Int2CharMap.FastEntrySet int2CharEntrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private int findKey(int k) {
        int[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (key[i] != k) continue;
            return i;
        }
        return -1;
    }

    @Override
    public char get(int k) {
        int[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            if (key[i] != k) continue;
            return this.value[i];
        }
        return this.defRetValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean containsKey(int k) {
        return this.findKey(k) != -1;
    }

    @Override
    public boolean containsValue(char v) {
        char[] value = this.value;
        int i = this.size;
        while (i-- != 0) {
            if (value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public char put(int k, char v) {
        int oldKey = this.findKey(k);
        if (oldKey != -1) {
            char oldValue = this.value[oldKey];
            this.value[oldKey] = v;
            return oldValue;
        }
        if (this.size == this.key.length) {
            int[] newKey = new int[this.size == 0 ? 2 : this.size * 2];
            char[] newValue = new char[this.size == 0 ? 2 : this.size * 2];
            int i = this.size;
            while (i-- != 0) {
                newKey[i] = this.key[i];
                newValue[i] = this.value[i];
            }
            this.key = newKey;
            this.value = newValue;
        }
        this.key[this.size] = k;
        this.value[this.size] = v;
        ++this.size;
        return this.defRetValue;
    }

    @Override
    public char remove(int k) {
        int oldPos = this.findKey(k);
        if (oldPos == -1) {
            return this.defRetValue;
        }
        char oldValue = this.value[oldPos];
        int tail = this.size - oldPos - 1;
        System.arraycopy(this.key, oldPos + 1, this.key, oldPos, tail);
        System.arraycopy(this.value, oldPos + 1, this.value, oldPos, tail);
        --this.size;
        return oldValue;
    }

    @Override
    public IntSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public CharCollection values() {
        if (this.values == null) {
            this.values = new ValuesCollection();
        }
        return this.values;
    }

    public Int2CharArrayMap clone() {
        Int2CharArrayMap c;
        try {
            c = (Int2CharArrayMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.key = (int[])this.key.clone();
        c.value = (char[])this.value.clone();
        c.entries = null;
        c.keys = null;
        c.values = null;
        return c;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int[] key = this.key;
        char[] value = this.value;
        int max = this.size;
        for (int i = 0; i < max; ++i) {
            s.writeInt(key[i]);
            s.writeChar(value[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.key = new int[this.size];
        int[] key = this.key;
        this.value = new char[this.size];
        char[] value = this.value;
        for (int i = 0; i < this.size; ++i) {
            key[i] = s.readInt();
            value[i] = s.readChar();
        }
    }

    private final class ValuesCollection
    extends AbstractCharCollection {
        private ValuesCollection() {
        }

        @Override
        public boolean contains(char v) {
            return Int2CharArrayMap.this.containsValue(v);
        }

        @Override
        public CharIterator iterator() {
            return new /* Unavailable Anonymous Inner Class!! */;
        }

        @Override
        public CharSpliterator spliterator() {
            return new ValuesSpliterator(this, 0, Int2CharArrayMap.this.size);
        }

        @Override
        public void forEach(CharConsumer action) {
            char[] value = Int2CharArrayMap.this.value;
            int max = Int2CharArrayMap.this.size;
            for (int i = 0; i < max; ++i) {
                action.accept(value[i]);
            }
        }

        @Override
        public int size() {
            return Int2CharArrayMap.this.size;
        }

        @Override
        public void clear() {
            Int2CharArrayMap.this.clear();
        }
    }

    private final class KeySet
    extends AbstractIntSet {
        private KeySet() {
        }

        @Override
        public boolean contains(int k) {
            return Int2CharArrayMap.this.findKey(k) != -1;
        }

        @Override
        public boolean remove(int k) {
            int oldPos = Int2CharArrayMap.this.findKey(k);
            if (oldPos == -1) {
                return false;
            }
            int tail = Int2CharArrayMap.this.size - oldPos - 1;
            System.arraycopy(Int2CharArrayMap.this.key, oldPos + 1, Int2CharArrayMap.this.key, oldPos, tail);
            System.arraycopy(Int2CharArrayMap.this.value, oldPos + 1, Int2CharArrayMap.this.value, oldPos, tail);
            --Int2CharArrayMap.this.size;
            return true;
        }

        @Override
        public IntIterator iterator() {
            return new /* Unavailable Anonymous Inner Class!! */;
        }

        @Override
        public IntSpliterator spliterator() {
            return new KeySetSpliterator(this, 0, Int2CharArrayMap.this.size);
        }

        @Override
        public void forEach(IntConsumer action) {
            int[] key = Int2CharArrayMap.this.key;
            int max = Int2CharArrayMap.this.size;
            for (int i = 0; i < max; ++i) {
                action.accept(key[i]);
            }
        }

        @Override
        public int size() {
            return Int2CharArrayMap.this.size;
        }

        @Override
        public void clear() {
            Int2CharArrayMap.this.clear();
        }
    }

    private final class EntrySet
    extends AbstractObjectSet<Int2CharMap.Entry>
    implements Int2CharMap.FastEntrySet {
        private EntrySet() {
        }

        @Override
        public ObjectIterator<Int2CharMap.Entry> iterator() {
            return new /* Unavailable Anonymous Inner Class!! */;
        }

        @Override
        public ObjectIterator<Int2CharMap.Entry> fastIterator() {
            return new /* Unavailable Anonymous Inner Class!! */;
        }

        @Override
        public ObjectSpliterator<Int2CharMap.Entry> spliterator() {
            return new EntrySetSpliterator(this, 0, Int2CharArrayMap.this.size);
        }

        @Override
        public void forEach(Consumer<? super Int2CharMap.Entry> action) {
            int[] key = Int2CharArrayMap.this.key;
            char[] value = Int2CharArrayMap.this.value;
            int max = Int2CharArrayMap.this.size;
            for (int i = 0; i < max; ++i) {
                action.accept((Int2CharMap.Entry)new AbstractInt2CharMap.BasicEntry(key[i], value[i]));
            }
        }

        @Override
        public void fastForEach(Consumer<? super Int2CharMap.Entry> action) {
            int[] key = Int2CharArrayMap.this.key;
            char[] value = Int2CharArrayMap.this.value;
            AbstractInt2CharMap.BasicEntry entry = new AbstractInt2CharMap.BasicEntry();
            int max = Int2CharArrayMap.this.size;
            for (int i = 0; i < max; ++i) {
                entry.key = key[i];
                entry.value = value[i];
                action.accept((Int2CharMap.Entry)entry);
            }
        }

        @Override
        public int size() {
            return Int2CharArrayMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getKey() == null || !(e.getKey() instanceof Integer)) {
                return false;
            }
            if (e.getValue() == null || !(e.getValue() instanceof Character)) {
                return false;
            }
            int k = (Integer)e.getKey();
            return Int2CharArrayMap.this.containsKey(k) && Int2CharArrayMap.this.get(k) == ((Character)e.getValue()).charValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getKey() == null || !(e.getKey() instanceof Integer)) {
                return false;
            }
            if (e.getValue() == null || !(e.getValue() instanceof Character)) {
                return false;
            }
            int k = (Integer)e.getKey();
            char v = ((Character)e.getValue()).charValue();
            int oldPos = Int2CharArrayMap.this.findKey(k);
            if (oldPos == -1 || v != Int2CharArrayMap.this.value[oldPos]) {
                return false;
            }
            int tail = Int2CharArrayMap.this.size - oldPos - 1;
            System.arraycopy(Int2CharArrayMap.this.key, oldPos + 1, Int2CharArrayMap.this.key, oldPos, tail);
            System.arraycopy(Int2CharArrayMap.this.value, oldPos + 1, Int2CharArrayMap.this.value, oldPos, tail);
            --Int2CharArrayMap.this.size;
            return true;
        }
    }
}

