import * as BabelTypes from '@babel/types';
import { Config } from './config';
interface I18NextParsedOptions {
    contexts: string[] | boolean;
    hasCount: boolean;
    ns: string | null;
    keyPrefix: string | null;
    defaultValue: string | null;
}
/**
 * Key as extracted by an extractor.
 */
export interface ExtractedKey {
    key: string;
    parsedOptions: I18NextParsedOptions;
    sourceNodes: BabelTypes.Node[];
    extractorName: string;
}
/**
 * Extracted key with enriched information.
 */
export interface TranslationKey extends ExtractedKey {
    cleanKey: string;
    keyPath: string[];
    ns: string;
    isDerivedKey: boolean;
}
/**
 * Compute all derived keys for a local from a key and parsed i18next options.
 *
 * e.g.
 *   ({'foo', {contexts: false, hasCount: true}}, 'en')
 *     => ['foo', 'foo_plural']
 *   ({'bar', {contexts: ['male', 'female'], hasCount: true}}, 'en')
 *     => ['foo_male', 'foo_male_plural', 'foo_female', 'foo_female_plural']
 *
 * FIXME: some of the work of this function should be delegated to the exporter.
 * This function should just put derivation metadata (each plural for the current
 * locale and each context) into an attribute of the key. The exporter should then
 * produce the actual value of the key using the metadata from the TranslationKey.
 * This would remove the need to specify JSONvX-specific code into this
 * function, but it will be easier to do when we drop support for JSONv3.
 *
 * @param extractedKey key that was extracted with an extractor.
 * @param locale locale code
 * @returns All derived keys that could be found from TranslationKey for
 *   locale.
 */
export declare function computeDerivedKeys(extractedKey: ExtractedKey, locale: string, config: Config): TranslationKey[];
export {};
