"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("@typescript-eslint/utils");
const tsutils = __importStar(require("ts-api-utils"));
const ts = __importStar(require("typescript"));
const util_1 = require("../util");
var Usefulness;
(function (Usefulness) {
    Usefulness["Always"] = "always";
    Usefulness["Never"] = "will";
    Usefulness["Sometimes"] = "may";
})(Usefulness || (Usefulness = {}));
exports.default = (0, util_1.createRule)({
    name: 'no-base-to-string',
    meta: {
        type: 'suggestion',
        docs: {
            description: 'Require `.toString()` and `.toLocaleString()` to only be called on objects which provide useful information when stringified',
            recommended: 'recommended',
            requiresTypeChecking: true,
        },
        messages: {
            baseArrayJoin: "Using `join()` for {{name}} {{certainty}} use Object's default stringification format ('[object Object]') when stringified.",
            baseToString: "'{{name}}' {{certainty}} use Object's default stringification format ('[object Object]') when stringified.",
        },
        schema: [
            {
                type: 'object',
                additionalProperties: false,
                properties: {
                    ignoredTypeNames: {
                        type: 'array',
                        description: 'Stringified regular expressions of type names to ignore.',
                        items: {
                            type: 'string',
                        },
                    },
                },
            },
        ],
    },
    defaultOptions: [
        {
            ignoredTypeNames: ['Error', 'RegExp', 'URL', 'URLSearchParams'],
        },
    ],
    create(context, [option]) {
        const services = (0, util_1.getParserServices)(context);
        const checker = services.program.getTypeChecker();
        const ignoredTypeNames = option.ignoredTypeNames ?? [];
        function checkExpression(node, type) {
            if (node.type === utils_1.AST_NODE_TYPES.Literal) {
                return;
            }
            const certainty = collectToStringCertainty(type ?? services.getTypeAtLocation(node));
            if (certainty === Usefulness.Always) {
                return;
            }
            context.report({
                node,
                messageId: 'baseToString',
                data: {
                    name: context.sourceCode.getText(node),
                    certainty,
                },
            });
        }
        function checkExpressionForArrayJoin(node, type) {
            const certainty = collectJoinCertainty(type);
            if (certainty === Usefulness.Always) {
                return;
            }
            context.report({
                node,
                messageId: 'baseArrayJoin',
                data: {
                    name: context.sourceCode.getText(node),
                    certainty,
                },
            });
        }
        function collectUnionTypeCertainty(type, collectSubTypeCertainty) {
            const certainties = type.types.map(t => collectSubTypeCertainty(t));
            if (certainties.every(certainty => certainty === Usefulness.Never)) {
                return Usefulness.Never;
            }
            if (certainties.every(certainty => certainty === Usefulness.Always)) {
                return Usefulness.Always;
            }
            return Usefulness.Sometimes;
        }
        function collectIntersectionTypeCertainty(type, collectSubTypeCertainty) {
            for (const subType of type.types) {
                const subtypeUsefulness = collectSubTypeCertainty(subType);
                if (subtypeUsefulness === Usefulness.Always) {
                    return Usefulness.Always;
                }
            }
            return Usefulness.Never;
        }
        function collectJoinCertainty(type) {
            if (tsutils.isUnionType(type)) {
                return collectUnionTypeCertainty(type, collectJoinCertainty);
            }
            if (tsutils.isIntersectionType(type)) {
                return collectIntersectionTypeCertainty(type, collectJoinCertainty);
            }
            if (checker.isTupleType(type)) {
                const typeArgs = checker.getTypeArguments(type);
                const certainties = typeArgs.map(t => collectToStringCertainty(t));
                if (certainties.some(certainty => certainty === Usefulness.Never)) {
                    return Usefulness.Never;
                }
                if (certainties.some(certainty => certainty === Usefulness.Sometimes)) {
                    return Usefulness.Sometimes;
                }
                return Usefulness.Always;
            }
            if (checker.isArrayType(type)) {
                const elemType = (0, util_1.nullThrows)(type.getNumberIndexType(), 'array should have number index type');
                return collectToStringCertainty(elemType);
            }
            return Usefulness.Always;
        }
        function collectToStringCertainty(type) {
            const toString = checker.getPropertyOfType(type, 'toString') ??
                checker.getPropertyOfType(type, 'toLocaleString');
            const declarations = toString?.getDeclarations();
            if (!toString || !declarations || declarations.length === 0) {
                return Usefulness.Always;
            }
            // Patch for old version TypeScript, the Boolean type definition missing toString()
            if (type.flags & ts.TypeFlags.Boolean ||
                type.flags & ts.TypeFlags.BooleanLiteral) {
                return Usefulness.Always;
            }
            if (ignoredTypeNames.includes((0, util_1.getTypeName)(checker, type))) {
                return Usefulness.Always;
            }
            if (declarations.every(({ parent }) => !ts.isInterfaceDeclaration(parent) || parent.name.text !== 'Object')) {
                return Usefulness.Always;
            }
            if (type.isIntersection()) {
                return collectIntersectionTypeCertainty(type, collectToStringCertainty);
            }
            if (!type.isUnion()) {
                return Usefulness.Never;
            }
            return collectUnionTypeCertainty(type, collectToStringCertainty);
        }
        function isBuiltInStringCall(node) {
            if (node.callee.type === utils_1.AST_NODE_TYPES.Identifier &&
                node.callee.name === 'String' &&
                node.arguments[0]) {
                const scope = context.sourceCode.getScope(node);
                const variable = scope.set.get('String');
                return !variable?.defs.length;
            }
            return false;
        }
        return {
            'AssignmentExpression[operator = "+="], BinaryExpression[operator = "+"]'(node) {
                const leftType = services.getTypeAtLocation(node.left);
                const rightType = services.getTypeAtLocation(node.right);
                if ((0, util_1.getTypeName)(checker, leftType) === 'string') {
                    checkExpression(node.right, rightType);
                }
                else if ((0, util_1.getTypeName)(checker, rightType) === 'string' &&
                    node.left.type !== utils_1.AST_NODE_TYPES.PrivateIdentifier) {
                    checkExpression(node.left, leftType);
                }
            },
            CallExpression(node) {
                if (isBuiltInStringCall(node)) {
                    checkExpression(node.arguments[0]);
                }
            },
            'CallExpression > MemberExpression.callee > Identifier[name = "join"].property'(node) {
                const memberExpr = node.parent;
                const type = (0, util_1.getConstrainedTypeAtLocation)(services, memberExpr.object);
                checkExpressionForArrayJoin(memberExpr.object, type);
            },
            'CallExpression > MemberExpression.callee > Identifier[name = /^(toLocaleString|toString)$/].property'(node) {
                const memberExpr = node.parent;
                checkExpression(memberExpr.object);
            },
            TemplateLiteral(node) {
                if (node.parent.type === utils_1.AST_NODE_TYPES.TaggedTemplateExpression) {
                    return;
                }
                for (const expression of node.expressions) {
                    checkExpression(expression);
                }
            },
        };
    },
});
//# sourceMappingURL=no-base-to-string.js.map