'use client';
'use strict';

var React = require('react');

function usePrevious(value) {
  const ref = React.useRef();
  React.useEffect(() => {
    ref.current = value;
  }, [value]);
  return ref.current;
}

exports.usePrevious = usePrevious;
//# sourceMappingURL=use-previous.cjs.map
