import { CSSProperties } from '../../core';
export declare function getElementHeight(el: React.RefObject<HTMLElement> | {
    current?: {
        scrollHeight: number;
    };
}): number | "auto";
interface UseCollapse {
    opened: boolean;
    transitionDuration?: number;
    transitionTimingFunction?: string;
    onTransitionEnd?: () => void;
}
interface GetCollapseProps {
    [key: string]: unknown;
    style?: CSSProperties;
    onTransitionEnd?: (e: TransitionEvent) => void;
    refKey?: string;
    ref?: React.ForwardedRef<HTMLDivElement>;
}
export declare function useCollapse({ transitionDuration, transitionTimingFunction, onTransitionEnd, opened, }: UseCollapse): (props: GetCollapseProps) => Record<string, any>;
export {};
