'use client';
'use strict';

var react = require('react');
var hooks = require('@mantine/hooks');

function useResizing({ transitionDuration, disabled }) {
  const [resizing, setResizing] = react.useState(true);
  const resizingTimeout = react.useRef();
  const disabledTimeout = react.useRef();
  hooks.useWindowEvent("resize", () => {
    setResizing(true);
    clearTimeout(resizingTimeout.current);
    resizingTimeout.current = window.setTimeout(
      () => react.startTransition(() => {
        setResizing(false);
      }),
      200
    );
  });
  hooks.useIsomorphicEffect(() => {
    setResizing(true);
    clearTimeout(disabledTimeout.current);
    disabledTimeout.current = window.setTimeout(
      () => react.startTransition(() => {
        setResizing(false);
      }),
      transitionDuration || 0
    );
  }, [disabled, transitionDuration]);
  return resizing;
}

exports.useResizing = useResizing;
//# sourceMappingURL=use-resizing.cjs.map
