import { RefObject } from "react";
export type THTML<C extends keyof JSX.IntrinsicElements> = Modify<JSX.IntrinsicElements[C], {
    ref?: ((instance: HTMLButtonElement | null) => void) | RefObject<HTMLButtonElement> | null;
}>;
export type TPaging = {
    index: number;
    size: number;
    totalDisplayableResults: number;
    totalResults?: number;
};
export declare enum ESortDirection {
    ASC = "asc",
    DESC = "desc",
    NONE = "none"
}
export type TSorting = {
    column: string;
    direction: ESortDirection;
};
export type Modify<T, R> = Omit<T, keyof R> & R;
export declare enum EStatus {
    SUCCESS = "success",
    INFO = "info",
    WARNING = "warning",
    ERROR = "error"
}
//# sourceMappingURL=genericTypes.d.ts.map