// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package sites

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteSiteAcceptedCode is the HTTP code returned for type DeleteSiteAccepted
const DeleteSiteAcceptedCode int = 202

/*
DeleteSiteAccepted Configuration change accepted and reload requested

swagger:response deleteSiteAccepted
*/
type DeleteSiteAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteSiteAccepted creates DeleteSiteAccepted with default headers values
func NewDeleteSiteAccepted() *DeleteSiteAccepted {

	return &DeleteSiteAccepted{}
}

// WithReloadID adds the reloadId to the delete site accepted response
func (o *DeleteSiteAccepted) WithReloadID(reloadID string) *DeleteSiteAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete site accepted response
func (o *DeleteSiteAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteSiteAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteSiteNoContentCode is the HTTP code returned for type DeleteSiteNoContent
const DeleteSiteNoContentCode int = 204

/*
DeleteSiteNoContent Site deleted

swagger:response deleteSiteNoContent
*/
type DeleteSiteNoContent struct {
}

// NewDeleteSiteNoContent creates DeleteSiteNoContent with default headers values
func NewDeleteSiteNoContent() *DeleteSiteNoContent {

	return &DeleteSiteNoContent{}
}

// WriteResponse to the client
func (o *DeleteSiteNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteSiteNotFoundCode is the HTTP code returned for type DeleteSiteNotFound
const DeleteSiteNotFoundCode int = 404

/*
DeleteSiteNotFound The specified resource was not found

swagger:response deleteSiteNotFound
*/
type DeleteSiteNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteSiteNotFound creates DeleteSiteNotFound with default headers values
func NewDeleteSiteNotFound() *DeleteSiteNotFound {

	return &DeleteSiteNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete site not found response
func (o *DeleteSiteNotFound) WithConfigurationVersion(configurationVersion string) *DeleteSiteNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete site not found response
func (o *DeleteSiteNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete site not found response
func (o *DeleteSiteNotFound) WithPayload(payload *models.Error) *DeleteSiteNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete site not found response
func (o *DeleteSiteNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteSiteNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteSiteDefault General Error

swagger:response deleteSiteDefault
*/
type DeleteSiteDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteSiteDefault creates DeleteSiteDefault with default headers values
func NewDeleteSiteDefault(code int) *DeleteSiteDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteSiteDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete site default response
func (o *DeleteSiteDefault) WithStatusCode(code int) *DeleteSiteDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete site default response
func (o *DeleteSiteDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete site default response
func (o *DeleteSiteDefault) WithConfigurationVersion(configurationVersion string) *DeleteSiteDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete site default response
func (o *DeleteSiteDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete site default response
func (o *DeleteSiteDefault) WithPayload(payload *models.Error) *DeleteSiteDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete site default response
func (o *DeleteSiteDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteSiteDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
