// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package ring

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceRingOKCode is the HTTP code returned for type ReplaceRingOK
const ReplaceRingOKCode int = 200

/*
ReplaceRingOK Ring replaced

swagger:response replaceRingOK
*/
type ReplaceRingOK struct {

	/*
	  In: Body
	*/
	Payload *models.Ring `json:"body,omitempty"`
}

// NewReplaceRingOK creates ReplaceRingOK with default headers values
func NewReplaceRingOK() *ReplaceRingOK {

	return &ReplaceRingOK{}
}

// WithPayload adds the payload to the replace ring o k response
func (o *ReplaceRingOK) WithPayload(payload *models.Ring) *ReplaceRingOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace ring o k response
func (o *ReplaceRingOK) SetPayload(payload *models.Ring) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceRingOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceRingAcceptedCode is the HTTP code returned for type ReplaceRingAccepted
const ReplaceRingAcceptedCode int = 202

/*
ReplaceRingAccepted Configuration change accepted and reload requested

swagger:response replaceRingAccepted
*/
type ReplaceRingAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Ring `json:"body,omitempty"`
}

// NewReplaceRingAccepted creates ReplaceRingAccepted with default headers values
func NewReplaceRingAccepted() *ReplaceRingAccepted {

	return &ReplaceRingAccepted{}
}

// WithReloadID adds the reloadId to the replace ring accepted response
func (o *ReplaceRingAccepted) WithReloadID(reloadID string) *ReplaceRingAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace ring accepted response
func (o *ReplaceRingAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace ring accepted response
func (o *ReplaceRingAccepted) WithPayload(payload *models.Ring) *ReplaceRingAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace ring accepted response
func (o *ReplaceRingAccepted) SetPayload(payload *models.Ring) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceRingAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceRingBadRequestCode is the HTTP code returned for type ReplaceRingBadRequest
const ReplaceRingBadRequestCode int = 400

/*
ReplaceRingBadRequest Bad request

swagger:response replaceRingBadRequest
*/
type ReplaceRingBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceRingBadRequest creates ReplaceRingBadRequest with default headers values
func NewReplaceRingBadRequest() *ReplaceRingBadRequest {

	return &ReplaceRingBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace ring bad request response
func (o *ReplaceRingBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceRingBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace ring bad request response
func (o *ReplaceRingBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace ring bad request response
func (o *ReplaceRingBadRequest) WithPayload(payload *models.Error) *ReplaceRingBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace ring bad request response
func (o *ReplaceRingBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceRingBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceRingNotFoundCode is the HTTP code returned for type ReplaceRingNotFound
const ReplaceRingNotFoundCode int = 404

/*
ReplaceRingNotFound The specified resource was not found

swagger:response replaceRingNotFound
*/
type ReplaceRingNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceRingNotFound creates ReplaceRingNotFound with default headers values
func NewReplaceRingNotFound() *ReplaceRingNotFound {

	return &ReplaceRingNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace ring not found response
func (o *ReplaceRingNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceRingNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace ring not found response
func (o *ReplaceRingNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace ring not found response
func (o *ReplaceRingNotFound) WithPayload(payload *models.Error) *ReplaceRingNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace ring not found response
func (o *ReplaceRingNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceRingNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceRingDefault General Error

swagger:response replaceRingDefault
*/
type ReplaceRingDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceRingDefault creates ReplaceRingDefault with default headers values
func NewReplaceRingDefault(code int) *ReplaceRingDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceRingDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace ring default response
func (o *ReplaceRingDefault) WithStatusCode(code int) *ReplaceRingDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace ring default response
func (o *ReplaceRingDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace ring default response
func (o *ReplaceRingDefault) WithConfigurationVersion(configurationVersion string) *ReplaceRingDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace ring default response
func (o *ReplaceRingDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace ring default response
func (o *ReplaceRingDefault) WithPayload(payload *models.Error) *ReplaceRingDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace ring default response
func (o *ReplaceRingDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceRingDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
