use crate::dsl::{Feature::*, Inst, Location::*, VexLength::*};
use crate::dsl::{align, fmt, inst, r, rex, rw, sxl, sxq, vex, w};

#[rustfmt::skip] // Keeps instructions on a single line.
pub fn list() -> Vec<Inst> {
    vec![
        inst("addb", fmt("I", [rw(al), r(imm8)]), rex(0x4).ib(), _64b | compat),
        inst("addw", fmt("I", [rw(ax), r(imm16)]), rex([0x66, 0x5]).iw(), _64b | compat),
        inst("addl", fmt("I", [rw(eax), r(imm32)]), rex(0x5).id(), _64b | compat),
        inst("addq", fmt("I_SXL", [rw(rax), sxq(imm32)]), rex(0x5).w().id(), _64b),
        inst("addb", fmt("MI", [rw(rm8), r(imm8)]), rex(0x80).digit(0).ib(), _64b | compat),
        inst("addw", fmt("MI", [rw(rm16), r(imm16)]), rex([0x66, 0x81]).digit(0).iw(), _64b | compat),
        inst("addl", fmt("MI", [rw(rm32), r(imm32)]), rex(0x81).digit(0).id(), _64b | compat),
        inst("addq", fmt("MI_SXL", [rw(rm64), sxq(imm32)]), rex(0x81).w().digit(0).id(), _64b),
        inst("addl", fmt("MI_SXB", [rw(rm32), sxl(imm8)]), rex(0x83).digit(0).ib(), _64b | compat),
        inst("addq", fmt("MI_SXB", [rw(rm64), sxq(imm8)]), rex(0x83).w().digit(0).ib(), _64b),
        inst("addb", fmt("MR", [rw(rm8), r(r8)]), rex(0x0).r(), _64b | compat),
        inst("addw", fmt("MR", [rw(rm16), r(r16)]), rex([0x66, 0x1]).r(), _64b | compat),
        inst("addl", fmt("MR", [rw(rm32), r(r32)]), rex(0x1).r(), _64b | compat),
        inst("addq", fmt("MR", [rw(rm64), r(r64)]), rex(0x1).w().r(), _64b),
        inst("addb", fmt("RM", [rw(r8), r(rm8)]), rex(0x2).r(), _64b | compat),
        inst("addw", fmt("RM", [rw(r16), r(rm16)]), rex([0x66, 0x3]).r(), _64b | compat),
        inst("addl", fmt("RM", [rw(r32), r(rm32)]), rex(0x3).r(), _64b | compat),
        inst("addq", fmt("RM", [rw(r64), r(rm64)]), rex(0x3).w().r(), _64b),
        // Add with carry.
        inst("adcb", fmt("I", [rw(al), r(imm8)]), rex(0x14).ib(), _64b | compat),
        inst("adcw", fmt("I", [rw(ax), r(imm16)]), rex([0x66, 0x15]).iw(), _64b | compat),
        inst("adcl", fmt("I", [rw(eax), r(imm32)]), rex(0x15).id(), _64b | compat),
        inst("adcq", fmt("I_SXL", [rw(rax), sxq(imm32)]), rex(0x15).w().id(), _64b),
        inst("adcb", fmt("MI", [rw(rm8), r(imm8)]), rex(0x80).digit(2).ib(), _64b | compat),
        inst("adcw", fmt("MI", [rw(rm16), r(imm16)]), rex([0x66, 0x81]).digit(2).iw(), _64b | compat),
        inst("adcl", fmt("MI", [rw(rm32), r(imm32)]), rex(0x81).digit(2).id(), _64b | compat),
        inst("adcq", fmt("MI_SXL", [rw(rm64), sxq(imm32)]), rex(0x81).w().digit(2).id(), _64b),
        inst("adcl", fmt("MI_SXB", [rw(rm32), sxl(imm8)]), rex(0x83).digit(2).ib(), _64b | compat),
        inst("adcq", fmt("MI_SXB", [rw(rm64), sxq(imm8)]), rex(0x83).w().digit(2).ib(), _64b),
        inst("adcb", fmt("MR", [rw(rm8), r(r8)]), rex(0x10).r(), _64b | compat),
        inst("adcw", fmt("MR", [rw(rm16), r(r16)]), rex([0x66, 0x11]).r(), _64b | compat),
        inst("adcl", fmt("MR", [rw(rm32), r(r32)]), rex(0x11).r(), _64b | compat),
        inst("adcq", fmt("MR", [rw(rm64), r(r64)]), rex(0x11).w().r(), _64b),
        inst("adcb", fmt("RM", [rw(r8), r(rm8)]), rex(0x12).r(), _64b | compat),
        inst("adcw", fmt("RM", [rw(r16), r(rm16)]), rex([0x66, 0x13]).r(), _64b | compat),
        inst("adcl", fmt("RM", [rw(r32), r(rm32)]), rex(0x13).r(), _64b | compat),
        inst("adcq", fmt("RM", [rw(r64), r(rm64)]), rex(0x13).w().r(), _64b),
        // `LOCK`-prefixed memory-writing instructions.
        inst("lock_addb", fmt("MI", [rw(m8), r(imm8)]), rex([0xf0, 0x80]).digit(0).ib(), _64b | compat),
        inst("lock_addw", fmt("MI", [rw(m16), r(imm16)]), rex([0xf0, 0x66, 0x81]).digit(0).iw(), _64b | compat),
        inst("lock_addl", fmt("MI", [rw(m32), r(imm32)]), rex([0xf0, 0x81]).digit(0).id(), _64b | compat),
        inst("lock_addq", fmt("MI_SXL", [rw(m64), sxq(imm32)]), rex([0xf0, 0x81]).w().digit(0).id(), _64b),
        inst("lock_addl", fmt("MI_SXB", [rw(m32), sxl(imm8)]), rex([0xf0, 0x83]).digit(0).ib(), _64b | compat),
        inst("lock_addq", fmt("MI_SXB", [rw(m64), sxq(imm8)]), rex([0xf0, 0x83]).w().digit(0).ib(), _64b),
        inst("lock_addb", fmt("MR", [rw(m8), r(r8)]), rex([0xf0, 0x0]).r(), _64b | compat),
        inst("lock_addw", fmt("MR", [rw(m16), r(r16)]), rex([0xf0, 0x66, 0x1]).r(), _64b | compat),
        inst("lock_addl", fmt("MR", [rw(m32), r(r32)]), rex([0xf0, 0x1]).r(), _64b | compat),
        inst("lock_addq", fmt("MR", [rw(m64), r(r64)]), rex([0xf0, 0x1]).w().r(), _64b),
        inst("lock_adcb", fmt("MI", [rw(m8), r(imm8)]), rex([0xf0, 0x80]).digit(2).ib(), _64b | compat),
        inst("lock_adcw", fmt("MI", [rw(m16), r(imm16)]), rex([0xf0, 0x66, 0x81]).digit(2).iw(), _64b | compat),
        inst("lock_adcl", fmt("MI", [rw(m32), r(imm32)]), rex([0xf0, 0x81]).digit(2).id(), _64b | compat),
        inst("lock_adcq", fmt("MI_SXL", [rw(m64), sxq(imm32)]), rex([0xf0, 0x81]).w().digit(2).id(), _64b),
        inst("lock_adcl", fmt("MI_SXB", [rw(m32), sxl(imm8)]), rex([0xf0, 0x83]).digit(2).ib(), _64b | compat),
        inst("lock_adcq", fmt("MI_SXB", [rw(m64), sxq(imm8)]), rex([0xf0, 0x83]).w().digit(2).ib(), _64b),
        inst("lock_adcb", fmt("MR", [rw(m8), r(r8)]), rex([0xf0, 0x10]).r(), _64b | compat),
        inst("lock_adcw", fmt("MR", [rw(m16), r(r16)]), rex([0xf0, 0x66, 0x11]).r(), _64b | compat),
        inst("lock_adcl", fmt("MR", [rw(m32), r(r32)]), rex([0xf0, 0x11]).r(), _64b | compat),
        inst("lock_adcq", fmt("MR", [rw(m64), r(r64)]), rex([0xf0, 0x11]).w().r(), _64b),
        // Vector instructions.
        inst("addss", fmt("A", [rw(xmm1), r(xmm_m32)]), rex([0xF3, 0x0F, 0x58]).r(), _64b | compat | sse),
        inst("addsd", fmt("A", [rw(xmm1), r(xmm_m64)]), rex([0xF2, 0x0F, 0x58]).r(), _64b | compat | sse2),
        inst("addps", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x0F, 0x58]).r(), _64b | compat | sse),
        inst("addpd", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0x58]).r(), _64b | compat | sse2),
        inst("paddb", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0xFC]).r(), _64b | compat | sse2),
        inst("paddw", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0xFD]).r(), _64b | compat | sse2),
        inst("paddd", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0xFE]).r(), _64b | compat | sse2),
        inst("paddq", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0xD4]).r(), _64b | compat | sse2),
        inst("paddsb", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0xEC]).r(), _64b | compat | sse2),
        inst("paddsw", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0xED]).r(), _64b | compat | sse2),
        inst("paddusb", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0xDC]).r(), _64b | compat | sse2),
        inst("paddusw", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0xDD]).r(), _64b | compat | sse2),
        inst("phaddw", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0x38, 0x01]).r(), _64b | compat | ssse3),
        inst("phaddd", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0x38, 0x02]).r(), _64b | compat | ssse3),
        // Vex instructions
        inst("vaddps", fmt("B", [w(xmm1), r(xmm2), r(xmm_m128)]), vex(L128)._0f().op(0x58), _64b | compat | avx),
        inst("vaddpd", fmt("B", [w(xmm1), r(xmm2), r(xmm_m128)]), vex(L128)._66()._0f().op(0x58), _64b | compat | avx),
    ]
}
