package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyLoadBalancerAttribute invokes the ens.ModifyLoadBalancerAttribute API synchronously
func (client *Client) ModifyLoadBalancerAttribute(request *ModifyLoadBalancerAttributeRequest) (response *ModifyLoadBalancerAttributeResponse, err error) {
	response = CreateModifyLoadBalancerAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyLoadBalancerAttributeWithChan invokes the ens.ModifyLoadBalancerAttribute API asynchronously
func (client *Client) ModifyLoadBalancerAttributeWithChan(request *ModifyLoadBalancerAttributeRequest) (<-chan *ModifyLoadBalancerAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyLoadBalancerAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyLoadBalancerAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyLoadBalancerAttributeWithCallback invokes the ens.ModifyLoadBalancerAttribute API asynchronously
func (client *Client) ModifyLoadBalancerAttributeWithCallback(request *ModifyLoadBalancerAttributeRequest, callback func(response *ModifyLoadBalancerAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyLoadBalancerAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyLoadBalancerAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyLoadBalancerAttributeRequest is the request struct for api ModifyLoadBalancerAttribute
type ModifyLoadBalancerAttributeRequest struct {
	*requests.RpcRequest
	LoadBalancerName string `position:"Query" name:"LoadBalancerName"`
	LoadBalancerId   string `position:"Query" name:"LoadBalancerId"`
}

// ModifyLoadBalancerAttributeResponse is the response struct for api ModifyLoadBalancerAttribute
type ModifyLoadBalancerAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyLoadBalancerAttributeRequest creates a request to invoke ModifyLoadBalancerAttribute API
func CreateModifyLoadBalancerAttributeRequest() (request *ModifyLoadBalancerAttributeRequest) {
	request = &ModifyLoadBalancerAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "ModifyLoadBalancerAttribute", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyLoadBalancerAttributeResponse creates a response to parse from ModifyLoadBalancerAttribute response
func CreateModifyLoadBalancerAttributeResponse() (response *ModifyLoadBalancerAttributeResponse) {
	response = &ModifyLoadBalancerAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
