package eais

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachEai invokes the eais.AttachEai API synchronously
func (client *Client) AttachEai(request *AttachEaiRequest) (response *AttachEaiResponse, err error) {
	response = CreateAttachEaiResponse()
	err = client.DoAction(request, response)
	return
}

// AttachEaiWithChan invokes the eais.AttachEai API asynchronously
func (client *Client) AttachEaiWithChan(request *AttachEaiRequest) (<-chan *AttachEaiResponse, <-chan error) {
	responseChan := make(chan *AttachEaiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachEai(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachEaiWithCallback invokes the eais.AttachEai API asynchronously
func (client *Client) AttachEaiWithCallback(request *AttachEaiRequest, callback func(response *AttachEaiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachEaiResponse
		var err error
		defer close(result)
		response, err = client.AttachEai(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachEaiRequest is the request struct for api AttachEai
type AttachEaiRequest struct {
	*requests.RpcRequest
	ClientInstanceId             string `position:"Query" name:"ClientInstanceId"`
	ElasticAcceleratedInstanceId string `position:"Query" name:"ElasticAcceleratedInstanceId"`
}

// AttachEaiResponse is the response struct for api AttachEai
type AttachEaiResponse struct {
	*responses.BaseResponse
	RequestId                    string `json:"RequestId" xml:"RequestId"`
	ElasticAcceleratedInstanceId string `json:"ElasticAcceleratedInstanceId" xml:"ElasticAcceleratedInstanceId"`
	ClientInstanceId             string `json:"ClientInstanceId" xml:"ClientInstanceId"`
}

// CreateAttachEaiRequest creates a request to invoke AttachEai API
func CreateAttachEaiRequest() (request *AttachEaiRequest) {
	request = &AttachEaiRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eais", "2019-06-24", "AttachEai", "eais", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAttachEaiResponse creates a response to parse from AttachEai response
func CreateAttachEaiResponse() (response *AttachEaiResponse) {
	response = &AttachEaiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
