package dypnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCertifyResult invokes the dypnsapi.GetCertifyResult API synchronously
func (client *Client) GetCertifyResult(request *GetCertifyResultRequest) (response *GetCertifyResultResponse, err error) {
	response = CreateGetCertifyResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetCertifyResultWithChan invokes the dypnsapi.GetCertifyResult API asynchronously
func (client *Client) GetCertifyResultWithChan(request *GetCertifyResultRequest) (<-chan *GetCertifyResultResponse, <-chan error) {
	responseChan := make(chan *GetCertifyResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCertifyResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCertifyResultWithCallback invokes the dypnsapi.GetCertifyResult API asynchronously
func (client *Client) GetCertifyResultWithCallback(request *GetCertifyResultRequest, callback func(response *GetCertifyResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCertifyResultResponse
		var err error
		defer close(result)
		response, err = client.GetCertifyResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCertifyResultRequest is the request struct for api GetCertifyResult
type GetCertifyResultRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ProductCode          string           `position:"Query" name:"ProductCode"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Token                string           `position:"Query" name:"Token"`
}

// GetCertifyResultResponse is the response struct for api GetCertifyResult
type GetCertifyResultResponse struct {
	*responses.BaseResponse
	Code      string     `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetCertifyResultRequest creates a request to invoke GetCertifyResult API
func CreateGetCertifyResultRequest() (request *GetCertifyResultRequest) {
	request = &GetCertifyResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dypnsapi", "2017-05-25", "GetCertifyResult", "", "")
	request.Method = requests.POST
	return
}

// CreateGetCertifyResultResponse creates a response to parse from GetCertifyResult response
func CreateGetCertifyResultResponse() (response *GetCertifyResultResponse) {
	response = &GetCertifyResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
