package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTaskDetail invokes the devops_rdc.UpdateTaskDetail API synchronously
func (client *Client) UpdateTaskDetail(request *UpdateTaskDetailRequest) (response *UpdateTaskDetailResponse, err error) {
	response = CreateUpdateTaskDetailResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTaskDetailWithChan invokes the devops_rdc.UpdateTaskDetail API asynchronously
func (client *Client) UpdateTaskDetailWithChan(request *UpdateTaskDetailRequest) (<-chan *UpdateTaskDetailResponse, <-chan error) {
	responseChan := make(chan *UpdateTaskDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTaskDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTaskDetailWithCallback invokes the devops_rdc.UpdateTaskDetail API asynchronously
func (client *Client) UpdateTaskDetailWithCallback(request *UpdateTaskDetailRequest, callback func(response *UpdateTaskDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTaskDetailResponse
		var err error
		defer close(result)
		response, err = client.UpdateTaskDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTaskDetailRequest is the request struct for api UpdateTaskDetail
type UpdateTaskDetailRequest struct {
	*requests.RpcRequest
	Note              string           `position:"Body" name:"Note"`
	ExecutorId        string           `position:"Body" name:"ExecutorId"`
	StartDate         string           `position:"Body" name:"StartDate"`
	DelInvolvers      string           `position:"Body" name:"DelInvolvers"`
	Content           string           `position:"Body" name:"Content"`
	SprintId          string           `position:"Body" name:"SprintId"`
	CustomFieldId     string           `position:"Body" name:"CustomFieldId"`
	ProjectId         string           `position:"Body" name:"ProjectId"`
	TaskId            string           `position:"Body" name:"TaskId"`
	TaskFlowStatusId  string           `position:"Body" name:"TaskFlowStatusId"`
	TagIds            string           `position:"Body" name:"TagIds"`
	AddInvolvers      string           `position:"Body" name:"AddInvolvers"`
	Priority          requests.Integer `position:"Body" name:"Priority"`
	OrgId             string           `position:"Body" name:"OrgId"`
	DueDate           string           `position:"Body" name:"DueDate"`
	WorkTimes         requests.Integer `position:"Body" name:"WorkTimes"`
	StoryPoint        string           `position:"Body" name:"StoryPoint"`
	CustomFieldValues string           `position:"Body" name:"CustomFieldValues"`
}

// UpdateTaskDetailResponse is the response struct for api UpdateTaskDetail
type UpdateTaskDetailResponse struct {
	*responses.BaseResponse
	Successful bool   `json:"Successful" xml:"Successful"`
	ErrorCode  string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Object     bool   `json:"Object" xml:"Object"`
}

// CreateUpdateTaskDetailRequest creates a request to invoke UpdateTaskDetail API
func CreateUpdateTaskDetailRequest() (request *UpdateTaskDetailRequest) {
	request = &UpdateTaskDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "UpdateTaskDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateTaskDetailResponse creates a response to parse from UpdateTaskDetail response
func CreateUpdateTaskDetailResponse() (response *UpdateTaskDetailResponse) {
	response = &UpdateTaskDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
