package ddospro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstancePage invokes the ddospro.DescribeInstancePage API synchronously
// api document: https://help.aliyun.com/api/ddospro/describeinstancepage.html
func (client *Client) DescribeInstancePage(request *DescribeInstancePageRequest) (response *DescribeInstancePageResponse, err error) {
	response = CreateDescribeInstancePageResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstancePageWithChan invokes the ddospro.DescribeInstancePage API asynchronously
// api document: https://help.aliyun.com/api/ddospro/describeinstancepage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeInstancePageWithChan(request *DescribeInstancePageRequest) (<-chan *DescribeInstancePageResponse, <-chan error) {
	responseChan := make(chan *DescribeInstancePageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstancePage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstancePageWithCallback invokes the ddospro.DescribeInstancePage API asynchronously
// api document: https://help.aliyun.com/api/ddospro/describeinstancepage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeInstancePageWithCallback(request *DescribeInstancePageRequest, callback func(response *DescribeInstancePageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstancePageResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstancePage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstancePageRequest is the request struct for api DescribeInstancePage
type DescribeInstancePageRequest struct {
	*requests.RpcRequest
	SourceIp        string           `position:"Query" name:"SourceIp"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage     requests.Integer `position:"Query" name:"CurrentPage"`
	InstanceIdList  *[]string        `position:"Query" name:"InstanceIdList"  type:"Repeated"`
	IpList          *[]string        `position:"Query" name:"IpList"  type:"Repeated"`
}

// DescribeInstancePageResponse is the response struct for api DescribeInstancePage
type DescribeInstancePageResponse struct {
	*responses.BaseResponse
	RequestId    string         `json:"RequestId" xml:"RequestId"`
	Total        int            `json:"Total" xml:"Total"`
	InstanceList []InstanceInfo `json:"InstanceList" xml:"InstanceList"`
}

// CreateDescribeInstancePageRequest creates a request to invoke DescribeInstancePage API
func CreateDescribeInstancePageRequest() (request *DescribeInstancePageRequest) {
	request = &DescribeInstancePageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DDoSPro", "2017-07-25", "DescribeInstancePage", "", "")
	return
}

// CreateDescribeInstancePageResponse creates a response to parse from DescribeInstancePage response
func CreateDescribeInstancePageResponse() (response *DescribeInstancePageResponse) {
	response = &DescribeInstancePageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
