package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SuspendService invokes the cloudcallcenter.SuspendService API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/suspendservice.html
func (client *Client) SuspendService(request *SuspendServiceRequest) (response *SuspendServiceResponse, err error) {
	response = CreateSuspendServiceResponse()
	err = client.DoAction(request, response)
	return
}

// SuspendServiceWithChan invokes the cloudcallcenter.SuspendService API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/suspendservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SuspendServiceWithChan(request *SuspendServiceRequest) (<-chan *SuspendServiceResponse, <-chan error) {
	responseChan := make(chan *SuspendServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SuspendService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SuspendServiceWithCallback invokes the cloudcallcenter.SuspendService API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/suspendservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SuspendServiceWithCallback(request *SuspendServiceRequest, callback func(response *SuspendServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SuspendServiceResponse
		var err error
		defer close(result)
		response, err = client.SuspendService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SuspendServiceRequest is the request struct for api SuspendService
type SuspendServiceRequest struct {
	*requests.RpcRequest
	OwnerUid requests.Integer `position:"Query" name:"OwnerUid"`
}

// SuspendServiceResponse is the response struct for api SuspendService
type SuspendServiceResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateSuspendServiceRequest creates a request to invoke SuspendService API
func CreateSuspendServiceRequest() (request *SuspendServiceRequest) {
	request = &SuspendServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "SuspendService", "", "")
	request.Method = requests.POST
	return
}

// CreateSuspendServiceResponse creates a response to parse from SuspendService response
func CreateSuspendServiceResponse() (response *SuspendServiceResponse) {
	response = &SuspendServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
