package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNumberInfo invokes the cloudcallcenter.GetNumberInfo API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getnumberinfo.html
func (client *Client) GetNumberInfo(request *GetNumberInfoRequest) (response *GetNumberInfoResponse, err error) {
	response = CreateGetNumberInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetNumberInfoWithChan invokes the cloudcallcenter.GetNumberInfo API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getnumberinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetNumberInfoWithChan(request *GetNumberInfoRequest) (<-chan *GetNumberInfoResponse, <-chan error) {
	responseChan := make(chan *GetNumberInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNumberInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNumberInfoWithCallback invokes the cloudcallcenter.GetNumberInfo API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getnumberinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetNumberInfoWithCallback(request *GetNumberInfoRequest, callback func(response *GetNumberInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNumberInfoResponse
		var err error
		defer close(result)
		response, err = client.GetNumberInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNumberInfoRequest is the request struct for api GetNumberInfo
type GetNumberInfoRequest struct {
	*requests.RpcRequest
	Number string `position:"Query" name:"Number"`
}

// GetNumberInfoResponse is the response struct for api GetNumberInfo
type GetNumberInfoResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetNumberInfoRequest creates a request to invoke GetNumberInfo API
func CreateGetNumberInfoRequest() (request *GetNumberInfoRequest) {
	request = &GetNumberInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetNumberInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateGetNumberInfoResponse creates a response to parse from GetNumberInfo response
func CreateGetNumberInfoResponse() (response *GetNumberInfoResponse) {
	response = &GetNumberInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
