package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpgradeInstance invokes the aegis.UpgradeInstance API synchronously
// api document: https://help.aliyun.com/api/aegis/upgradeinstance.html
func (client *Client) UpgradeInstance(request *UpgradeInstanceRequest) (response *UpgradeInstanceResponse, err error) {
	response = CreateUpgradeInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// UpgradeInstanceWithChan invokes the aegis.UpgradeInstance API asynchronously
// api document: https://help.aliyun.com/api/aegis/upgradeinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpgradeInstanceWithChan(request *UpgradeInstanceRequest) (<-chan *UpgradeInstanceResponse, <-chan error) {
	responseChan := make(chan *UpgradeInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpgradeInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpgradeInstanceWithCallback invokes the aegis.UpgradeInstance API asynchronously
// api document: https://help.aliyun.com/api/aegis/upgradeinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpgradeInstanceWithCallback(request *UpgradeInstanceRequest, callback func(response *UpgradeInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpgradeInstanceResponse
		var err error
		defer close(result)
		response, err = client.UpgradeInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpgradeInstanceRequest is the request struct for api UpgradeInstance
type UpgradeInstanceRequest struct {
	*requests.RpcRequest
	InstanceId  string           `position:"Query" name:"InstanceId"`
	ClientToken string           `position:"Query" name:"ClientToken"`
	VmNumber    requests.Integer `position:"Query" name:"VmNumber"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	VersionCode requests.Integer `position:"Query" name:"VersionCode"`
}

// UpgradeInstanceResponse is the response struct for api UpgradeInstance
type UpgradeInstanceResponse struct {
	*responses.BaseResponse
	OrderId   string `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpgradeInstanceRequest creates a request to invoke UpgradeInstance API
func CreateUpgradeInstanceRequest() (request *UpgradeInstanceRequest) {
	request = &UpgradeInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "UpgradeInstance", "vipaegis", "openAPI")
	return
}

// CreateUpgradeInstanceResponse creates a response to parse from UpgradeInstance response
func CreateUpgradeInstanceResponse() (response *UpgradeInstanceResponse) {
	response = &UpgradeInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
