# -*- coding: utf-8 -*-

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.

from gallery_dl.extractor import urlgalleries


__tests__ = (
{
    "#url"     : "https://urlgalleries.net/b/photos2q/porn-gallery-7851311/clarice-window-8",
    "#category": ("", "urlgalleries", "gallery"),
    "#class"   : urlgalleries.UrlgalleriesGalleryExtractor,
    "#range"   : "1-3",
    "#urls"    : (
        "https://fappic.com/x207mqkn2463/4gq1yv.jpg",
        "https://fappic.com/q684ua2rp0j9/4gq1xv.jpg",
        "https://fappic.com/8vf3n8fgz9po/4gq1ya.jpg",
    ),

    "blog"      : "photos2q",
    "count"     : 39,
    "date"      : "dt:2023-12-08 13:59:00",
    "gallery_id": "7851311",
    "num"       : range(1, 3),
    "title"     : "Clarice window 8",
},

{
    "#url"     : "https://photos2q.urlgalleries.net/porn-gallery-7851311/clarice-window-8",
    "#category": ("", "urlgalleries", "gallery"),
    "#class"   : urlgalleries.UrlgalleriesGalleryExtractor,
    "#range"   : "1-3",
    "#urls"    : (
        "https://fappic.com/x207mqkn2463/4gq1yv.jpg",
        "https://fappic.com/q684ua2rp0j9/4gq1xv.jpg",
        "https://fappic.com/8vf3n8fgz9po/4gq1ya.jpg",
    ),

    "blog"      : "photos2q",
    "count"     : 39,
    "date"      : "dt:2023-12-08 13:59:00",
    "gallery_id": "7851311",
    "num"       : range(1, 3),
    "title"     : "Clarice window 8",
},

{
    "#url"     : "https://dreamer.urlgalleries.net/7645840",
    "#category": ("", "urlgalleries", "gallery"),
    "#class"   : urlgalleries.UrlgalleriesGalleryExtractor,
    "#range"   : "1-3",
    "#urls"    : (
        "https://www.fappic.com/vj7up04ny487/AmourAngels-0001.jpg",
        "https://www.fappic.com/zfgsmpm36iyv/AmourAngels-0002.jpg",
        "https://www.fappic.com/rqpt37rdbwa5/AmourAngels-0003.jpg",
    ),

    "blog"      : "Dreamer",
    "count"     : 105,
    "date"      : "dt:2020-03-10 21:17:00",
    "gallery_id": "7645840",
    "num"       : range(1, 3),
    "title"     : "Angelika - Rustic Charm - AmourAngels 2016-09-27",
},

)
