# -*- coding: utf-8 -*-

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.

from gallery_dl.extractor import tapas
from gallery_dl import exception


__tests__ = (
{
    "#url"     : "https://tapas.io/series/just-leave-me-be",
    "#class"   : tapas.TapasSeriesExtractor,
    "#pattern" : tapas.TapasEpisodeExtractor.pattern,
    "#count"   : 128,
},

{
    "#url"     : "https://tapas.io/series/yona",
    "#comment" : "mature",
    "#class"   : tapas.TapasSeriesExtractor,
    "#pattern" : tapas.TapasEpisodeExtractor.pattern,
    "#count"   : 17,
},

{
    "#url"     : "https://tapas.io/episode/2068651",
    "#comment" : "book / html",
    "#class"   : tapas.TapasEpisodeExtractor,
    "#pattern" : "^text:",
    "#sha1_url": "0b53644c864a0a097f65accea6bb620be9671078",

    "book"            : True,
    "comment_cnt"     : int,
    "date"            : "dt:2021-02-23 16:02:07",
    "early_access"    : False,
    "escape_title"    : "You are a Tomb Raider (2)",
    "free"            : True,
    "id"              : 2068651,
    "like_cnt"        : int,
    "liked"           : bool,
    "mature"          : False,
    "next_ep_id"      : 2068652,
    "nsfw"            : False,
    "nu"              : False,
    "num"             : 1,
    "open_comments"   : True,
    "pending_scene"   : 2,
    "prev_ep_id"      : 2068650,
    "publish_date"    : "2021-02-23T16:02:07Z",
    "read"            : bool,
    "related_ep_id"   : None,
    "relative_publish_date": "Feb 23, 2021",
    "scene"           : 2,
    "scheduled"       : False,
    "title"           : "You are a Tomb Raider (2)",
    "unlock_cnt"      : 0,
    "unlocked"        : False,
    "view_cnt"        : int,
    "series"          : {
        "genre"         : dict,
        "has_book_cover": True,
        "has_top_banner": True,
        "id"            : 199931,
        "premium"       : True,
        "sale_type"     : "WAIT_OR_MUST_PAY",
        "subscribed"    : bool,
        "thumbsup_cnt"  : int,
        "title"         : "Tomb Raider King",
        "type"          : "BOOKS",
        "url"           : "tomb-raider-king-novel",
    },
},

{
    "#url"     : "https://tapas.io/episode/2717154",
    "#comment" : "comic / jpg",
    "#class"   : tapas.TapasEpisodeExtractor,
    "#pattern" : r"https://us-a\.tapas\.io/pc/\w\w/[0-9a-f-]{36}(-\d)?\.jpg\?__token__=.+",
    "#count"   : 63,

    "book"         : False,
    "closing"      : None,
    "closing_date" : None,
    "comment_cnt"  : range(330, 500),
    "date"         : "dt:2023-01-13 19:00:00",
    "early_access" : False,
    "escape_title" : "Episode 3",
    "extension"    : "jpg",
    "filename"     : str,
    "free"         : True,
    "free_access"  : False,
    "has_bgm"      : False,
    "id"           : 2717154,
    "like_cnt"     : range(7000, 20000),
    "liked"        : False,
    "mature"       : False,
    "must_pay"     : False,
    "next_ep_id"   : 2717157,
    "nsfw"         : False,
    "nu"           : False,
    "num"          : range(1, 63),
    "open_comments": True,
    "pending_scene": 3,
    "prev_ep_id"   : 2717153,
    "publish_date" : "2023-01-13T19:00:00Z",
    "read"         : False,
    "related_ep_id": None,
    "relative_publish_date": "Jan 13, 2023",
    "scene"        : 3,
    "scheduled"    : False,
    "thumb_url"    : "https://us-a.tapas.io/sa/f9/a42d3c2f-d642-4481-9583-1d3bacbd302b.png",
    "title"        : "Episode 3",
    "unlock_cnt"   : 0,
    "unlocked"     : False,
    "view_cnt"     : range(70000, 200000),
    "series"       : {
        "badges"        : list,
        "book"          : False,
        "comic"         : True,
        "discount_rate" : int,
        "escape_title"  : "The Doctor Is Out",
        "genre"         : dict,
        "has_book_cover": True,
        "has_top_banner": True,
        "id"            : 251031,
        "item_type"     : None,
        "on_sale_now"   : False,
        "premium"       : True,
        "sale_type"     : "WAIT_OR_MUST_PAY",
        "subscribed"    : False,
        "thumb_url"     : "https://us-a.tapas.io/sa/32/7e1daa84-8951-4a53-9574-48ca7d0b0aca_m.jpg",
        "thumbsup_cnt"  : range(240000, 500000),
        "title"         : "The Doctor Is Out",
        "type"          : "COMICS",
        "url"           : "the-doctor-is-out",
    },
},

{
    "#url"      : "https://tapas.io/episode/2717157",
    "#comment"  : "locked",
    "#class"    : tapas.TapasEpisodeExtractor,
    "#exception": exception.AuthorizationError,
},

{
    "#url"     : "https://tapas.io/SANG123/series",
    "#comment" : "#5306",
    "#class"   : tapas.TapasCreatorExtractor,
    "#urls"    : (
        "https://tapas.io/series/the-return-of-the-disaster-class-hero",
        "https://tapas.io/series/the-return-of-the-disaster-class-hero-novel",
        "https://tapas.io/series/tomb-raider-king",
        "https://tapas.io/series/tomb-raider-king-novel",
    ),
},

)
